% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_dimensionreduction.R
\name{permuteExplVar}
\alias{permuteExplVar}
\title{Permute the expression values and retrieve the explained variance}
\usage{
permuteExplVar(x, n = 10, center = TRUE, scale = TRUE, sample_n = NULL)
}
\arguments{
\item{x}{\code{matrix} or \code{data.frame}, samples in columns and features 
in rows}

\item{n}{\code{numeric}, number of permutation rounds}

\item{center}{\code{logical}, passed to the function \code{explVar}}

\item{scale}{\code{logical}, passed to the function \code{explVar}}

\item{sample_n}{\code{numeric(1)}, number of features (subset) to be 
taken for calculation of permuted explained variance, the top 
\code{sample_n} varying values based on their standard deviation will be 
taken}
}
\value{
matrix with explained variance
}
\description{
The function \code{permuteExplVar} determines the explained variance of the 
permuted expression matrix (\code{x}). It is used to determine the optimal 
number of PCs for tSNE.
}
\details{
For the input of tSNE, typically, we want to reduce the initial number of 
dimensions linearly with PCA (used as the \code{initial_dims} arguments in 
the \code{Rtsne} funtion). The reduced data set is used for feeding 
into tSNE. By plotting the percentage of variance explained by the Princical
Components (PCs) we can estimate how many PCs we keep as input into tSNE.
However, if we select too many PCs, noise will be included as input to tSNE;
if we select too few PCs we might loose the important data structures. 
To get a better understanding how many PCs to include, randomization will
be employed and the observed variance will be compared to the permuted 
variance.
}
\examples{
 
x <- matrix(seq_len(100), nrow = 10, ncol = 10,
    dimnames = list(seq_len(10), paste("sample", seq_len(10))))
permuteExplVar(x = x, n = 10, center = TRUE, scale = TRUE, sample_n = NULL)

}
\author{
Thomas Naake
}
