% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_clusters.R
\name{extractMetaClusters}
\alias{extractMetaClusters}
\title{Extracts groups of reciprocal top hits from a 1-vs-best AUROC matrix.}
\usage{
extractMetaClusters(best_hits, threshold = 0)
}
\arguments{
\item{best_hits}{Matrix of AUROCs produced by MetaNeighborUS.}

\item{threshold}{AUROC threshold. Two clusters belong to the same
meta-cluster if they are reciprocal top hits and their similarity exceeds
the threshold *both* ways
(AUROC(1->2) > threshold *AND* AUROC(2->1) > threshold).}
}
\value{
A named list, where names are default meta-cluster names, and values
are vectors of cluster names, one vector per meta-cluster. The last element
of the list is called "outliers" and contains all clusters that had no match
in any other dataset.
}
\description{
Note that meta-clusters are *not* cliques, but connected components, e.g.,
if 1<->2 and 1<->3 are reciprocal top hits, {1, 2, 3} is a meta-cluster,
independently from the relationship between 2 and 3.
}
