% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{plotHeatmapPretrained}
\alias{plotHeatmapPretrained}
\title{Plots rectangular AUROC heatmap, clustering train cell types (columns)
by similarity, and ordering test cell types (rows) according to similarity
to train cell types..}
\usage{
plotHeatmapPretrained(
  aurocs,
  alpha_col = 1,
  alpha_row = 10,
  cex = 1,
  margins = c(8, 8)
)
}
\arguments{
\item{aurocs}{A rectangular AUROC matrix as returned by MetaNeighborUS,}

\item{alpha_col}{Parameter controling column clustering: a higher value of
alpha_col gives more weight to extreme AUROC values (close to 1).}

\item{alpha_row}{Parameter controling row ordering: a higher value of
alpha_row gives more weight to extreme AUROC values (close to 1).}

\item{cex}{Size factor for row and column labels.}

\item{margins}{Size of margins (for row and column labels).}
}
\description{
Plots rectangular AUROC heatmap, clustering train cell types (columns)
by similarity, and ordering test cell types (rows) according to similarity
to train cell types..
}
\examples{
data(mn_data)
var_genes = variableGenes(dat = mn_data, exp_labels = mn_data$study_id)
celltype_NV = MetaNeighborUS(var_genes = var_genes,
                             dat = mn_data,
                             study_id = mn_data$study_id,
                             cell_type = mn_data$cell_type,
                             symmetric_output = FALSE)
keep_col = getStudyId(colnames(celltype_NV)) == "GSE71585"
keep_row = getStudyId(rownames(celltype_NV)) != "GSE71585"
plotHeatmapPretrained(celltype_NV[keep_row, keep_col])

}
