% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topHits.R
\name{topHitsByStudy}
\alias{topHitsByStudy}
\title{Find reciprocal top hits, stratifying results by study.}
\usage{
topHitsByStudy(
  auroc,
  threshold = 0.9,
  n_digits = 2,
  collapse_duplicates = TRUE
)
}
\arguments{
\item{auroc}{matrix of celltype-to-celltype AUROC scores
(output from \code{\link{MetaNeighborUS}})}

\item{threshold}{AUROC threshold, must be between [0,1]. Default is 0.9.
Only top hits above this threshold are included in the result table.}

\item{n_digits}{Number of digits for AUROC values in the result table. Set
to "Inf" to skip rounding.}

\item{collapse_duplicates}{Collapse identical pairs of cell types (by
default), effectively averaging AUROCs when reference and target roles are
reversed. Setting this option to FALSE makes it easier to filter results
by study or cell type.
If collapse_duplicates is set to FALSE, "Celltype_1" is the
reference cell type and "Celltype_2" is the target cell type (relevant
if MetaNeighborUS was run with symmetric_output = FALSE).}
}
\value{
Function returns a dataframe with cell types that are either reciprocal best 
matches, and/or those with AUROC values greater than or equal to threshold 
value
}
\description{
This function looks for reciprocal top hits in each target study
separately, allowing for as many reciprocal top hits as target studies.
This is the recommended function for extracting top hits.
}
\examples{
data(mn_data)
var_genes = variableGenes(dat = mn_data, exp_labels = mn_data$study_id)
aurocs = MetaNeighborUS(var_genes = var_genes, 
                        dat = mn_data, 
                        study_id = mn_data$study_id,
                        cell_type = mn_data$cell_type)
top_hits = topHitsByStudy(aurocs)
top_hits

}
\seealso{
\code{\link{topHits}}
}
