% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompDbSource.R
\name{CompDbSource}
\alias{CompDbSource}
\alias{CompDbSource-class}
\alias{metadata,CompDbSource-method}
\alias{show,CompDbSource-method}
\alias{MassBankSource}
\title{Compound Annotation Sources for \code{CompDb} databases}
\usage{
CompDbSource(dbfile = character())

\S4method{metadata}{CompDbSource}(x, ...)

\S4method{show}{CompDbSource}(object)

MassBankSource(release = "2021.03", ...)
}
\arguments{
\item{dbfile}{\code{character(1)} with the database file (including the full
path).}

\item{x}{A \code{CompDbSource} object.}

\item{...}{For \code{CompDbSource}: ignored. For \code{MassBankSource}: optional
parameters passed to the \code{AnnotationHub} constructor function.}

\item{object}{A \code{CompDbSource} object.}

\item{release}{A \code{character(1)} defining the version/release of MassBank that
should be used.}
}
\description{
\code{CompDbSource} objects represent references to \link[CompoundDb:CompDb]{CompoundDb::CompDb}
database-backed annotation resources. Instances are expected to be
created with the dedicated construction functions such as
\code{MassBankSource} or the generic \code{CompDbSource}. The annotation data is
not stored within the object but will be accessed/loaded within the
object's \code{matchSpectra} method.

New \code{CompDbSource} objects can be created using the functions:
\itemize{
\item \code{CompDbSource}: create a new \code{CompDbSource} object from an existing
\code{CompDb} database. The (SQLite) database file (including the full path)
needs to be provided with parameter \code{dbfile}.
\item \code{MassBankSource}: retrieves a \code{CompDb} database for the specified MassBank
release from Bioconductor's online \code{AnnotationHub} (if it exists) and
uses that. Note that \code{AnnotationHub} resources are cached locally and thus
only downloaded the first time.
The function has parameters \code{release} which allows to define the desired
MassBank release (e.g. \code{release = "2021.03"} or \code{release = "2022.06"})
and \code{...} which allows to pass optional parameters to the \code{AnnotationHub}
constructor function, such as \code{localHub = TRUE} to use only the cached
data and avoid updating/retrieving updates from the internet.
}

Other functions:
\itemize{
\item \code{metadata}: get metadata (information) on the annotation resource.
}
}
\examples{

## Locate a CompDb SQLite database file. For this example we use the test
## database from the `CompoundDb` package.
fl <- system.file("sql", "CompDb.MassBank.sql", package = "CompoundDb")
ann_src <- CompDbSource(fl)

## The object contains only the reference/link to the annotation resource.
ann_src

## Retrieve a CompDb with MassBank data for a certain MassBank release
mb_src <- MassBankSource("2021.03")
mb_src
}
\author{
Johannes Rainer
}
