% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchFormula.R
\name{matchFormula}
\alias{matchFormula}
\alias{matchFormula,character,character-method}
\alias{matchFormula,data.frameOrSimilar,data.frameOrSimilar-method}
\alias{matchFormula,character,data.frameOrSimilar-method}
\alias{matchFormula,data.frameOrSimilar,character-method}
\title{Chemical Formula Matching}
\usage{
matchFormula(query, target, ...)

\S4method{matchFormula}{character,character}(query, target, BPPARAM = SerialParam())

\S4method{matchFormula}{data.frameOrSimilar,data.frameOrSimilar}(
  query,
  target,
  formulaColname = c("formula", "formula"),
  BPPARAM = SerialParam()
)

\S4method{matchFormula}{character,data.frameOrSimilar}(
  query,
  target,
  formulaColname = "formula",
  BPPARAM = SerialParam()
)

\S4method{matchFormula}{data.frameOrSimilar,character}(
  query,
  target,
  formulaColname = "formula",
  BPPARAM = SerialParam()
)
}
\arguments{
\item{query}{\code{character} or \code{data.frame} with chemical formulas to search.}

\item{target}{\code{character} or \code{data.frame} with chemical formulas to compare
against.}

\item{...}{currently ignored}

\item{BPPARAM}{parallel processing setup. See \code{BiocParallel::bpparam()} for
details.}

\item{formulaColname}{\code{character} with the name of the column containing
chemical formulas. Can be of length 1 if both \code{query} and \code{target} are
\code{data.frame}s and the name of the column with chemical formulas is the
same for both. If different columns are used, \code{formulaColname[1]} can be
used to define the column name in \code{query} and \code{formulaColname[2]} the
one of \code{target}.}
}
\value{
\link{Matched} object representing the result.
}
\description{
The \code{matchFormula} method matches chemical formulas from different inputs
(parameter \code{query} and \code{target}). Before comparison all formulas are
normalized using \code{\link[MetaboCoreUtils:standardizeFormula]{MetaboCoreUtils::standardizeFormula()}}. Inputs can be
either a \code{character} or \code{data.frame} containing a column with formulas.
In case of \code{data.frame}s parameter \code{formulaColname} needs to be used to
specify the name of the column containing the chemical formulas.
}
\examples{

## input formula
query <- c("H12C6O6", "C11H12O2", "HN3")
target <- c("HCl", "C2H4O", "C6H12O6")

query_df <- data.frame(
    formula = c("H12C6O6", "C11H12O2", "HN3"),
    name = c("A", "B", "C")
)
target_df <- data.frame(
    formula = c("HCl", "C2H4O", "C6H12O6"),
    name = c("D", "E", "F")
)

## character vs character
matches <- matchFormula(query, target)
matchedData(matches)

## data.frame vs data.frame
matches <- matchFormula(query_df, target_df)
matchedData(matches)
## data.frame vs character
matches <- matchFormula(query_df, target)
matchedData(matches)
## character vs data.frame
matches <- matchFormula(query, target_df)
matchedData(matches)
}
\author{
Michael Witting
}
