% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regulons.R
\name{get_tf_ES}
\alias{get_tf_ES}
\title{Calculate enrichment scores for each TF across all samples using
dorothea and viper.}
\usage{
get_tf_ES(exp, min.confidence = "B", regulons)
}
\arguments{
\item{exp}{Gene expression matrix with gene expression counts,
row as ENSG gene IDS and column as samples}

\item{min.confidence}{Minimun confidence score ("A", "B","C","D", "E")
classifying regulons based on their quality from Human DoRothEA database.
The default minimun confidence score is "B"}

\item{regulons}{DoRothEA regulons in table format. Same as \link[dorothea]{run_viper}.
If not specified Bioconductor (human) dorothea regulons besed on GTEx will be.
used \link[dorothea]{dorothea_hs}.}
}
\value{
A matrix of normalized enrichment scores for each TF across all samples
}
\description{
Calculate enrichment scores for each TF across all samples using
dorothea and viper.
}
\examples{
gene.exp.chr21.log2 <- get(data("gene.exp.chr21.log2"))
tf_es <- get_tf_ES(gene.exp.chr21.log2)
}
