% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichSMPDB.R
\name{enrichSMPDB}
\alias{enrichSMPDB}
\title{Metabolism enrichment analysis for microbiome data}
\usage{
enrichSMPDB(
  metabo_list,
  pvalueCutoff = 0.05,
  pAdjustMethod = "BH",
  universe,
  minGSSize = 10,
  maxGSSize = 500,
  qvalueCutoff = 0.2
)
}
\arguments{
\item{metabo_list}{a vector of metabolites in smpdb Metabolite.ID}

\item{pvalueCutoff}{adjusted pvalue cutoff on enrichment tests to report.}

\item{pAdjustMethod}{one of "holm", "hochberg", "hommel", "bonferroni",
"BH", "BY", "fdr", "none".}

\item{universe}{universe background genes. If missing, use SMPDB db.}

\item{minGSSize}{minimal size of genes annotated by KEGG term for testing.}

\item{maxGSSize}{maximal size of genes annotated for testing.}

\item{qvalueCutoff}{qvalue cutoff on enrichment tests to report.}
}
\value{
A \code{enrichResult} instance.
}
\description{
Metabolism enrichment analysis for microbiome data
}
\examples{

smp <- enrichSMPDB(c("PW_C000164","PW_C000078","PW_C000040"))
head(smp)

}
