% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClass.R
\name{MPSE}
\alias{MPSE}
\title{Construct a MPSE object}
\usage{
MPSE(
  assays,
  colData = NULL,
  otutree = NULL,
  taxatree = NULL,
  refseq = NULL,
  ...
)
}
\arguments{
\item{assays}{A 'list' or 'SimpleList' of matrix-like elements
All elements of the list must have the same dimensions, we also 
recommend they have names, e.g. list(Abundance=xx1, RareAbundance=xx2).}

\item{colData}{An optional DataFrame describing the samples.}

\item{otutree}{A treedata object of tidytree package, the result parsed by
the functions of treeio.}

\item{taxatree}{A treedata object of tidytree package, the result parsed by
the functions of treeio.}

\item{refseq}{A XStingSet object of Biostrings package, the result parsed by
the readDNAStringSet or readAAStringSet of Biostrings.}

\item{...}{additional parameters, see also the usage 
of \code{\link[SummarizedExperiment]{SummarizedExperiment}}.}
}
\value{
MPSE object
}
\description{
Construct a MPSE object
}
\examples{
set.seed(123)
xx <- matrix(abs(round(rnorm(100, sd=4), 0)), 10)
xx <- data.frame(xx)
rownames(xx) <- paste0("row", seq_len(10))
mpse <- MPSE(assays=xx)
mpse
}
