% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_frip.R
\name{calc_frip}
\alias{calc_frip}
\title{Calculate FRiP score}
\usage{
calc_frip(read_file, peak_file, single_end = TRUE, total_reads = NULL)
}
\arguments{
\item{read_file}{A BamFile object.}

\item{peak_file}{A GRanges object.}

\item{single_end}{A logical value. If TRUE, the reads classified as
single-ended. (default = TRUE)}

\item{total_reads}{(optional) The total number of reads in the experiment.
Skips counting the total number of reads if provided, saving computation.}
}
\value{
A numeric value indicating the FRiP score.
}
\description{
Calculate the Fraction of Reads in Peak score from the read and peak file
of an experiment.
}
\details{
The FRiP score is calculated as follows:
\deqn{\text{FRiP} = \frac{(\text{number of reads in peaks})}{\text{(total number of reads)}}}
}
\examples{
read_file <- system.file("extdata", "CTCF_ChIP_alignment.bam",
                        package = "MotifPeeker")
read_file <- Rsamtools::BamFile(read_file)
data("CTCF_ChIP_peaks", package = "MotifPeeker")

calc_frip(read_file, CTCF_ChIP_peaks)

}
