% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_repeats.R
\name{filter_repeats}
\alias{filter_repeats}
\title{Filter motifs with nucleotide repeats}
\usage{
filter_repeats(motifs, filter_n = 6)
}
\arguments{
\item{motifs}{Output from \code{\link[memes]{runStreme}}.}

\item{filter_n}{Minimum number of consecutive nucleotide repeats to filter.}
}
\value{
A list object with same structure as \code{motifs} but with motifs
containing \code{filter_n} or more consecutive nucleotide repeats removed.
}
\description{
Filter out motifs which contain \code{filter_n} or more consecutive
nucleotide repeats. This includes unambiguous bases such as 'Y', 'N, 'R',
etc.
}
\seealso{
\code{\link[memes]{runStreme}}
}
\keyword{internal}
