% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-msp.R
\name{readMsp}
\alias{readMsp}
\title{Reading MSP files}
\usage{
readMsp(
  f,
  msLevel = 2L,
  mapping = spectraVariableMapping(MsBackendMsp()),
  BPPARAM = SerialParam(),
  ...
)
}
\arguments{
\item{f}{\code{character(1)} with the path to an MSP file.}

\item{msLevel}{\code{numeric(1)} with the MS level. Default is 2. This value will
be reported as the spectra's MS level \strong{unless} the source MSP file
defines the MS level.}

\item{mapping}{named \code{character} vector to rename MSP fields to spectra
variables (see \code{spectraVariableMapping()} help). This allows to
correctly import also custom fields or data from files with different
MSP \emph{flavors}.}

\item{BPPARAM}{parallel processing setup. See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}}
for more details.}

\item{...}{Additional parameters, currently ignored.}
}
\value{
A \code{DataFrame} with each row containing the data from one spectrum
in the MSP file. m/z and intensity values are available in columns \code{"mz"}
and \code{"intensity"} in a list representation.
}
\description{
The \code{readMsp()} function imports the data from a file in MGF format reading
all specified fields and returning the data as a \code{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame()}}.

Format constraints for MSP files:
\itemize{
\item Comment lines are expected to start with a \verb{#}.
\item Multiple spectra within the same MSP file are separated by an empty line.
\item The first n lines of a spectrum entry represent metadata.
\item Metadata is provided as "name: value" pairs (i.e. name and value separated
by a ":").
\item One line per mass peak, with values separated by a whitespace or tabulator.
\item Each line is expected to contain at least the m/z and intensity values (in
that order) of a peak. Additional values are currently ignored.
}
}
\examples{

f <- system.file("extdata", "minimona.msp", package = "MsBackendMsp")

readMsp(f)
}
\author{
Laurent Gatto, Steffen Neumann, Johannes Rainer
}
