% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_Spectra_metrics.R
\name{ticQuartileToQuartileLogRatio}
\alias{ticQuartileToQuartileLogRatio}
\title{MS1 TIC-change quartile ratios (MS:4000057) or  
MS1 TIC quartile ratios (MS:4000058)}
\usage{
ticQuartileToQuartileLogRatio(
  spectra,
  relativeTo = c("previous", "Q1"),
  mode = c("TIC_change", "TIC"),
  msLevel = 1L,
  ...
)
}
\arguments{
\item{spectra}{\code{Spectra} object}

\item{relativeTo}{\code{character(1)}, one of \code{"Q1"} or 
\code{"previous"}}

\item{mode}{\code{character(1)}, one of \code{"TIC_change"} or \code{"TIC"}}

\item{msLevel}{\code{integer}}

\item{...}{not used here}
}
\value{
\code{numeric(1)}
}
\description{
MS:4000057 \cr
"The log ratios of successive TIC-change quartiles. The TIC changes are 
the list of MS1 total ion current (TIC) value changes from one to the next 
scan, produced when each MS1 TIC is subtracted from the preceding MS1 TIC. 
The metric's value triplet represents the log ratio of the TIC-change 
Q2 to Q1, Q3 to Q2, TIC-change-max to Q3" [PSI:MS] \cr 
For calculation of MS:400057 set \code{mode = "TIC_change"}. \cr

MS:4000058 \cr
"The log ratios of successive TIC quartiles. The metric's value triplet 
represents the log ratios of TIC-Q2 to TIC-Q1, TIC-Q3 to TIC-Q2, 
TIC-max to TIC-Q3." [PSI:MS] \cr
For calculation of MS:400058 set \code{mode = "TIC"}. \cr

The metric is calculated as follows: \cr
(1) the TIC (\code{ionCount}) of the \code{Spectra} object is calculated 
per scan event (with spectra ordered by retention time), \cr
(2) for *MS:4000057*, the differences between TIC values are calculated 
between subsequent scan events,
for *MS:4000058*, the TIC values between subsequent scan events are taken
as they are, \cr
(3) for *MS:4000057* and *MS:4000058* the ratios between the 25\%, 50\%, 
75\%, and 100\% quantile to the 25\% quantile of the values of (2) are 
calculated.
Alternatively, if \code{relativeTo = "Q1"}, the ratios are calculated 
between the 50\%/25\%, 75\%/25\%, and 100\%/25\% quantiles, \cr
(4) The \code{log} values of the ratios are returned. \cr
}
\details{
MS:4000057 \cr
synonym: "MS1-TIC-Change-Q2" RELATED [PMID:24494671] \cr
synonym: "MS1-TIC-Change-Q3" RELATED [PMID:24494671] \cr
synonym: "MS1-TIC-Change-Q4" RELATED [PMID:24494671] \cr
is_a: MS:4000004 ! n-tuple \cr
relationship: has_metric_category MS:4000009 ! ID free metric \cr
relationship: has_metric_category MS:4000012 ! single run based metric \cr
relationship: has_metric_category MS:4000017 ! chromatogram metric \cr
relationship: has_metric_category MS:4000021 ! MS1 metric \cr
relationship: has_value_type xsd:float ! The allowed value-type for this CV term \cr
relationship: has_value_concept STATO:0000105 ! log signal intensity ratio \cr

MS:4000058 \cr
synonym: "MS1-TIC-Q2" RELATED [PMID:24494671] \cr
synonym: "MS1-TIC-Q3" RELATED [PMID:24494671] \cr
synonym: "MS1-TIC-Q4" RELATED [PMID:24494671] \cr
is_a: MS:4000004 ! n-tuple \cr
relationship: has_metric_category MS:4000009 ! ID free metric \cr
relationship: has_metric_category MS:4000012 ! single run based metric \cr
relationship: has_metric_category MS:4000017 ! chromatogram metric \cr
relationship: has_metric_category MS:4000021 ! MS1 metric \cr
relationship: has_value_type xsd:float ! The allowed value-type for this CV term \cr
relationship: has_value_concept STATO:0000105 ! log signal intensity ratio \cr

An attribute containing the PSI:MS term will only be returned if 
\code{relativeTo} is \code{"previous"} and \code{msLevel} is 1.
}
\note{
This function interprets the *quantiles* from the [PSI:MS] definition as
*quartiles*, i.e. the 0, 25, 50, 75 and 100\% quantiles are used.
}
\examples{
library(S4Vectors)
library(Spectra)

spd <- DataFrame(
    msLevel = c(2L, 2L, 2L),
    polarity = c(1L, 1L, 1L),
    id = c("HMDB0000001", "HMDB0000001", "HMDB0001847"),
    name = c("1-Methylhistidine", "1-Methylhistidine", "Caffeine"))
## Assign m/z and intensity values
spd$mz <- list(
    c(109.2, 124.2, 124.5, 170.16, 170.52),
    c(83.1, 96.12, 97.14, 109.14, 124.08, 125.1, 170.16),
    c(56.0494, 69.0447, 83.0603, 109.0395, 110.0712,
        111.0551, 123.0429, 138.0662, 195.0876))
spd$intensity <- list(
    c(3.407, 47.494, 3.094, 100.0, 13.240),
    c(6.685, 4.381, 3.022, 16.708, 100.0, 4.565, 40.643),
    c(0.459, 2.585, 2.446, 0.508, 8.968, 0.524, 0.974, 100.0, 40.994))
sps <- Spectra(spd)

## MS:4000057
ticQuartileToQuartileLogRatio(spectra = sps, relativeTo = "previous",
    msLevel = 2L, mode = "TIC_change")
ticQuartileToQuartileLogRatio(spectra = sps, relativeTo = "Q1",
    msLevel = 2L, mode = "TIC_change")

## MS:4000058
ticQuartileToQuartileLogRatio(spectra = sps, relativeTo = "previous",
    msLevel = 2L, mode = "TIC")
ticQuartileToQuartileLogRatio(spectra = sps, relativeTo = "Q1",
    msLevel = 2L, mode = "TIC")
}
\author{
Thomas Naake
}
