% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiBaC.R
\name{genModelList}
\alias{genModelList}
\title{genModelList}
\usage{
genModelList(mbac, test.comp = NULL, scale = FALSE, center = TRUE,
  crossval = NULL, showinfo = TRUE)
}
\arguments{
\item{mbac}{mbac object generated by *createMbac*.}

\item{test.comp}{Maximum number of components allowed for PLS models. If NULL (default), the minimal effective rank of the matrices is used as the maximum number of components.}

\item{scale}{Logical. Whether X and Y matrices must be scaled. By default, FALSE.}

\item{center}{Logical. Whether X and Y matrices must be centered. By default, TRUE.}

\item{crossval}{Integer: number of cross-validation segments. The number of samples (rows of 'x') must be at least >= crossvalI. If NULL (default) leave-one-out crossvalidation is performed.}

\item{showinfo}{Logical. Whether to show the information about the function progress. By default, TRUE.}
}
\value{
Custom mbac object. Elements in a mbac object:
\enumerate{
    \item ListOfBatches: A list of MultiAssayExperiment objects (one per batch).
    \item commonOmic: Name of the common omic between the batches.
    \item PLSmodels: PLS models created during MultiBaC method performance (one model per non-common omic data type).
    \item InnerRelation: Table of class data.frame containing the inner correlation (i.e. correlation between the scores of X (t) and Y (u) matrices) for each PLS model across all components.
}
}
\description{
This function performs PLS models for every batch. A PLS model is generated for each non-common omic in each batch.
}
\examples{
data('multiyeast')

my_mbac <- createMbac (inputOmics = list(A.rna, A.gro, B.rna, B.ribo, C.rna, C.par),
                       batchFactor = c("A", "A", "B", "B", "C", "C"),
                       experimentalDesign = list("A" =  c("Glu+", "Glu+",
                       "Glu+", "Glu-", "Glu-", "Glu-"),
                        "B" = c("Glu+", "Glu+", "Glu-", "Glu-"),
                         "C" = c("Glu+", "Glu+", "Glu-", "Glu-")),
                       omicNames = c("RNA", "GRO", "RNA", "RIBO", "RNA", "PAR"),
                       commonOmic = "RNA")

my_mbac_2 <- genModelList (my_mbac, test.comp = NULL,
                           scale = FALSE, center = TRUE,
                           crossval = NULL,
                           showinfo = TRUE)

}
