% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{inner_relPlot}
\alias{inner_relPlot}
\title{inner_relPLot}
\usage{
inner_relPlot(mbac, comp2plot = c(1, 2), ...)
}
\arguments{
\item{mbac}{Object of class mbac generated by *MultiBaC* or *genModelList*.}

\item{comp2plot}{Indicates which components are plotted. Default is "c(1,2)", which means that just the inner relation plot of components 1 and 2 are shown. If more components are indicated, the function will return as many plots as needed to show all the components.}

\item{...}{Other graphical parameters}
}
\value{
Inner relation plot for PLS models is displayed.
}
\description{
inner_relPLot
}
\examples{
data('multiyeast')

my_mbac <- createMbac (inputOmics = list(A.rna, A.gro, B.rna, B.ribo, C.rna, C.par),
                       batchFactor = c("A", "A", "B", "B", "C", "C"),
                       experimentalDesign = list("A" =  c("Glu+", "Glu+",
                       "Glu+", "Glu-", "Glu-", "Glu-"),
                       "B" = c("Glu+", "Glu+", "Glu-", "Glu-"),
                       "C" = c("Glu+", "Glu+", "Glu-", "Glu-")),
                       omicNames = c("RNA", "GRO", "RNA", "RIBO", "RNA", "PAR"))

my_final_mbac <- MultiBaC (my_mbac,
                           test.comp = NULL, scale = FALSE,
                           center = TRUE, crossval = NULL,
                           Variability = 0.90,
                           Interaction = TRUE ,
                           showplot = FALSE,
                           showinfo = FALSE)

inner_relPlot (my_final_mbac)

}
