% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEplotBarplotTime.R
\name{DEplotBarplotTime}
\alias{DEplotBarplotTime}
\title{Barplot of DE genes per time}
\usage{
DEplotBarplotTime(table.DE.time, Log2.FC.matrix)
}
\arguments{
\item{table.DE.time}{Binary matrix (table filled with 0 and 1) with
\eqn{N_g} rows and \eqn{T-1} columns with
\eqn{N_g} the number of genes and \eqn{T} the number of time points.}

\item{Log2.FC.matrix}{Numeric matrix with positive and negative with
\eqn{N_g} rows and \eqn{T-1} columns.}
}
\value{
The function plots two graphs:
a barplot showing the number of DE genes per time and
a barplot showing the number of under and over expressed genes per times.
}
\description{
The function takes as input two tables
\itemize{
\item a binary table with \eqn{N_g} rows corresponding to genes and
\eqn{T-1} columns corresponding to times
(with \eqn{T} the number of time points).
A '1' in the n-th row and i-th column means that the n-th gene is
differentially expressed (DE) at time ti,
compared with the reference time t0.
\item a numeric matrix with positive and negative values with
\eqn{N_g} rows corresponding to genes and \eqn{T-1} columns corresponding
to times.
The element in n-th row and i-th column corresponds to the log2 fold change
between the time ti and the reference time t0 for the n-th gene.
If the gene is DE and the sign is positive, then the gene n will be
considered as over-expressed (up-regulated) at the time ti.
If the gene is DE and the sign is negative, then the gene n will be
considered as under-expressed (down-regulated) at the time ti.
}

The function plots two graphs: a barplot showing the number of DE genes
per time and a barplot showing the number of under- and over-expressed
genes per times.
}
\examples{
set.seed(1994)
Dat1.FTP <- matrix(sample(c(0,1), replace=TRUE, size=120, prob=c(0.3,0.7)),
                   ncol=3)
Dat2.FTP <- matrix(round(rnorm(n=120, mean=0, sd=1), digits=2), ncol=3)
colnames(Dat1.FTP) <- paste0("t", seq_len(3))
colnames(Dat2.FTP) <- paste0("t", seq_len(3))
##-----------------------------------------------------------------------###
res.DE.all.t <- DEplotBarplotTime(table.DE.time=Dat1.FTP,
                                  Log2.FC.matrix=Dat2.FTP)
print(res.DE.all.t$g.nb.DEPerTime)
print(res.DE.all.t$g.nb.DEPerTime.sign)
}
