% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DEplotVolcanoMA.R
\name{DEplotVolcanoMA}
\alias{DEplotVolcanoMA}
\title{Volcano and MA graphs}
\usage{
DEplotVolcanoMA(
  SEresDE,
  NbGene.plotted = 2,
  SizeLabel = 3,
  Display.plots = FALSE,
  Save.plots = FALSE
)
}
\arguments{
\item{SEresDE}{A SummarizedExperiment class object. Output from
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}
(see \code{Examples}).}

\item{NbGene.plotted}{Non negative integer. The algorithm computes the sum
of all the absolute \eqn{log_2} fold change present in the element
\code{DE.results} of \code{Res.DE.analysis} for each gene.
Only the highest \code{NbGene.plotted} genes are plotted in the volcano and
MA plots. By default, \code{NbGene.plotted}=2.}

\item{SizeLabel}{Numeric. Give the size of the names of plotted genes.
By default, \code{SizeLabel}=3.}

\item{Display.plots}{\code{TRUE} or \code{FALSE}. \code{FALSE} as default.
If \code{TRUE}, all graphs will be plotted.
Otherwise no graph will be plotted.}

\item{Save.plots}{\code{TRUE} or \code{FALSE} or a Character.
\code{FALSE} as default. Path to save the Volcano and MA plots.
If \code{NULL}, the Volcano and MA plots will not be saved in a sub folder
in \code{path.result}.

If \code{path.result} contains a sub folder entitled "VolcanoPlots",
all the Volcano plots will be saved in the sub folder "VolcanoPlots".
Otherwise, a sub folder entitled "VolcanoPlots" will be created
in \code{path.result} and all the Volcano plots will be saved in
the sub folder created.

If \code{path.result} contains a sub folder entitled "MAplots",
all the MA plots will be saved in the sub folder "MAplots".
Otherwise, a sub folder entitled "MAplots" will be created in
\code{path.result} and all the MA plots will be saved in
the sub folder created.}
}
\value{
The function returns the same SummarizedExperiment class object
\code{SEresDE} with Volcano plots and MA plots from the results of
our function \code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}},
all saved in the metadata \code{Results[[2]][[3]]} of \code{SEresDE}.
}
\description{
The function returns Volcano plots and MA plots from
the results of our function
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}.
}
\details{
\itemize{
\item If data belong to different time points only, the function returns
\eqn{T-1} volcano and MA plots
(with \eqn{T} the number of time measurements), corresponding to the
\eqn{log_2} fold change between each time ti and the reference time t0,
for all \eqn{i>0}.
\item If data belong to different biological conditions only,
the function returns \eqn{(N_{bc}*(N_{bc}-1))/2} volcano and MA plots
(with \eqn{N_{bc}} the number of biological conditions),
corresponding to the \eqn{log_2} fold change between each pair of
biological condition.
\item If data belong to different biological conditions and time points,
the function returns
\itemize{
\item \eqn{(T-1)*N_{bc}} volcano and MA plots,
corresponding to the \eqn{log_2} fold change between each time ti and
the reference time t0, for all biological condition.
\item \eqn{((T-1)*N_{bc}*(N_{bc}-1))/2} volcano and MA plots,
corresponding to the \eqn{log_2} fold change between
each pair of biological conditions, for all fixed time point.
}
}
}
\examples{
## data importation
data(RawCounts_Antoszewski2022_MOUSEsub500)
## No time points. We take only two groups for the speed of the example
dataT1wt <- RawCounts_Antoszewski2022_MOUSEsub500[seq_len(200), seq_len(7)]

## Preprocessing with Results of DEanalysisGlobal()
resDATAprepSE <- DATAprepSE(RawCounts=dataT1wt,
                            Column.gene=1,
                            Group.position=1,
                            Time.position=NULL,
                            Individual.position=2)
##------------------------------------------------------------------------##
## DE analysis
resDET1wt <- DEanalysisGlobal(SEres=resDATAprepSE,
                              pval.min=0.05,
                              pval.vect.t=NULL,
                              log.FC.min=1,
                              LRT.supp.info=FALSE,
                              Plot.DE.graph=FALSE,
                              path.result=NULL,
                              Name.folder.DE=NULL)

##------------------------------------------------------------------------##
## Volcano MA
resVolcanoMA <- DEplotVolcanoMA(SEresDE=resDET1wt,
                                NbGene.plotted=5,
                                Display.plots=TRUE,
                                Save.plots=FALSE)
}
\seealso{
The function calls the output of
\code{\link[=DEanalysisGlobal]{DEanalysisGlobal()}}.
}
