% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_chr.R
\name{check_chr}
\alias{check_chr}
\title{Standardize the CHR column}
\usage{
check_chr(
  sumstats_dt,
  log_files,
  check_save_out,
  rmv_chr,
  nThread,
  tabix_index,
  log_folder_ind
)
}
\arguments{
\item{sumstats_dt}{data.table with summary statistics}

\item{log_files}{list of locations for all log files}

\item{check_save_out}{list of parameters for saved files}

\item{rmv_chr}{Chromosomes to exclude from the formatted summary statistics
file. Use NULL if no filtering is necessary. Default is \code{c("X", "Y", "MT")}
which removes all non-autosomal SNPs.}

\item{nThread}{Number of threads to use for parallel processes.}

\item{tabix_index}{Index the formatted summary statistics with
\href{http://www.htslib.org/doc/tabix.html}{tabix} for fast querying.}

\item{log_folder_ind}{Binary Should log files be stored containing all
filtered out SNPs (separate file per filter). The data is outputted in the
same format specified for the resulting sumstats file. The only exception to
this rule is if output is vcf, then log file saved as .tsv.gz. Default is
FALSE.}
}
\value{
list containing the updated summary statistics data.table and the
updated log file locations list
}
\description{
Maps chromosome names to the default Ensembl/NCBI naming style and removes
SNPs with nonstandard CHR entries. Optionally, also removes SNPs on
user-specified chromosomes.
}
\keyword{internal}
