% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{methods}
\name{NBAMSeq-methods}
\alias{NBAMSeq-methods}
\alias{getDesign}
\alias{getDesign,NBAMSeqDataSet-method}
\alias{getsf}
\alias{getsf,NBAMSeqDataSet-method}
\alias{setsf<-}
\alias{setsf<-,NBAMSeqDataSet,numeric-method}
\title{Accessor functions and replace methods for NBAMSeqDataSet object}
\usage{
getDesign(theObject)

\S4method{getDesign}{NBAMSeqDataSet}(theObject)

getsf(theObject)

\S4method{getsf}{NBAMSeqDataSet}(theObject)

setsf(theObject) <- value

\S4method{setsf}{NBAMSeqDataSet,numeric}(theObject) <- value
}
\arguments{
\item{theObject}{a NBAMSeqDataSet object}

\item{value}{the values to be included in the object}
}
\value{
For \code{getDesign()}: design formula

For \code{getsf()}: size factor

For \code{setsf()}: NBAMSeq object
}
\description{
Accessor functions and replace methods for NBAMSeqDataSet object

For \code{getDesign()}: accessor to the design formula

For \code{getsf()}: accessor to the size factors

Replace methods for NBAMSeqDataSet object

For \code{setsf()}: replace size factors
}
\examples{
## For getDesign() ##
gsd = makeExample()
design_gsd = getDesign(gsd)
## For getsf() ##
gsd = makeExample()
sf = getsf(gsd)
## For setsf() ##
n = 100
m = 50
gsd = makeExample(n = n, m = m)
sf = sample(1:5, m, replace = TRUE)
setsf(gsd) = sf
}
\references{
Love, M.I., Huber, W., Anders, S. (2014) Moderated estimation of
fold change and dispersion for RNA-seq data with DESeq2. Genome Biology,
15:550. \url{https://doi.org/10.1186/s13059-014-0550-8}
}
