% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NBAMSeq.R
\name{NBAMSeq}
\alias{NBAMSeq}
\title{Differential expression analysis based on negative binomial additive
model}
\usage{
NBAMSeq(object, gamma = 2.5, parallel = FALSE, fitlin = FALSE,
  BPPARAM = bpparam(), ...)
}
\arguments{
\item{object}{a NBAMSeqDataSet object}

\item{gamma}{a number greater or equal to 1. Increase gamma to create
smoother models. Default gamma is 2.5. See \code{\link[mgcv]{gam}} for
details.}

\item{parallel}{either TRUE or FALSE indicating whether parallel should be
used. Default is FALSE}

\item{fitlin}{either TRUE or FALSE indicating whether linear model should be
fitted. Default is FALSE}

\item{BPPARAM}{an argument provided to \code{\link{bplapply}}. See
\code{\link[BiocParallel]{register}} for details.}

\item{...}{additional arguments provided to \code{\link[mgcv]{gam}}}
}
\value{
a NBAMSeqDataSet object
}
\description{
This function performs differential expression analysis based
on negative binomial additive model.
}
\examples{
gsd = makeExample(n = 3, m = 10)
gsd = NBAMSeq(gsd)
}
\references{
Love, M.I., Huber, W., Anders, S. (2014) Moderated estimation of
fold change and dispersion for RNA-seq data with DESeq2. Genome Biology,
15:550. \url{https://doi.org/10.1186/s13059-014-0550-8}
}
