% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fitting.R
\name{fitSingleSigmoid}
\alias{fitSingleSigmoid}
\title{Fit sigmoid model}
\usage{
fitSingleSigmoid(x, y, start = c(Pl = 0, a = 550, b = 10))
}
\arguments{
\item{x}{numeric vector of the independent variables (typically temperature)}

\item{y}{numeric vector of the dependent variables (typically relative abundance measurements)}

\item{start}{numeric vector of start parameters for the melting curve equation}
}
\value{
model summary of type "nls"
}
\description{
Fit sigmoid model
}
\details{
Fits the following function to the data:
\eqn{y = (1 - Pl)  / (1+exp((b - a/x))) + Pl}
}
\examples{
data(stauro_TPP_data_tidy)
stk4 <- dplyr::filter(stauro_TPP_data_tidy, grepl("STK4", uniqueID))
fitSingleSigmoid(stk4$temperature, stk4$relAbundance)
}
