% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareSummarizedExperiment.R
\name{prepareSummarizedExperiment}
\alias{prepareSummarizedExperiment}
\title{Prepare a SummarizedExperiment for computing gene set scores computation}
\usage{
prepareSummarizedExperiment(SE, model)
}
\arguments{
\item{SE}{A `SummarizedExperiment`}

\item{model}{A string matching a model in `NetActivityData` or a custom
matrix.}
}
\value{
A `SummarizedExperiment` with the data prepared for gene set score
computation with `computeGeneSetScores`
}
\description{
This function will prepare the data for the computation of gene set scores.
The function will perform two steps. First, the function will check whether
the genes present in the trained model are present in the input
`SummarizedExperiment`. Missing genes will be set to 0 for all samples.
Second, the function will standardize the gene expression values, so gene
values have a mean of 0 and a standard deviation of 1.
}
\details{
Notice that the function will not accept raw count data. We recommend to
convert count data to continuous values using the Variant Stabilization
Transformation from [DESeq2::varianceStabilizingTransformation].

This function can also prepare the data for a model not present in
`NetActivityData`. In this case, `param` should be a matrix where the columns
are the genes and the rows the gene sets.
}
\examples{
library(airway)
data(airway)
ddsSE <- DESeq2::DESeqDataSet(airway, design = ~ cell + dex)
vst <- DESeq2::varianceStabilizingTransformation(ddsSE)
out <- prepareSummarizedExperiment(vst, "gtex_gokegg")
}
