% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNearest.R
\name{getTADOverlap}
\alias{getTADOverlap}
\title{For given region of interest, overlapped genes in the TAD regions are
found. Results can be filtered according to the available cell lines.}
\usage{
getTADOverlap(
  bedfile,
  org_assembly = c("hg19", "hg38", "mm10", "dre10", "rn6", "dm6", "ce11", "sc3"),
  tad = c(tad_hg19, tad_dmel, tad_hg38, tad_mm10),
  near = FALSE,
  upstream = 10000,
  downstream = 10000,
  cellline = "all"
)
}
\arguments{
\item{bedfile}{Region of interest}

\item{org_assembly}{Genome assembly of interest for the analysis. Possible
assemblies are "mm10" for mouse, "dre10" for zebrafish, "rn6" for rat,
"dm6" for fruit fly, "ce11" for worm, "sc3" for yeast, "hg19" and
"hg38" for human}

\item{tad}{TAD genomic regions for the species. Predefined TAD regions or
any new TAD regions can be used for the analysis. TAD regions must be
formated as GRanges object. Predefined TAD regions are 'tad_hg19',
'tad_hg38', 'tad_mm10', 'tad_dmel' for hg19, hg38, mm9 and dm6
assembly, respectively.}

\item{near}{Boolean value presents whether cis-neighbourhood should be
considered in the analysis}

\item{upstream}{Holds upstream distance from the transcription start
position}

\item{downstream}{Holds downstream distance from the transcription end
position}

\item{cellline}{Cell lines for TAD regions.}
}
\value{
List of protein coding genes that falls into the TAD regions
}
\description{
For given region of interest, overlapped genes in the TAD regions are
found. Results can be filtered according to the available cell lines.
}
\examples{
\dontrun{
regions<-system.file("extdata", "ncRegion.txt", package = "NoRCE")
regionNC <- rtracklayer::import(regions, format = "BED")

r<-getTADOverlap(bedfile = regionNC,
                 tad = tad_hg19,
                 org_assembly = 'hg19',
                 cellline = 'HUVEC')
}
}
