% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSeqORFs.r
\name{getSeqORFs}
\alias{getSeqORFs}
\title{Extract the sequences of identified open reading frames}
\usage{
getSeqORFs(orfs, tr, genome = "BSgenome.Hsapiens.UCSC.hg38", workDir = NULL)
}
\arguments{
\item{orfs}{character string giving the name of tab-delimited TXT file with
coordinates of open reading frame(-s). This file should include three
mandatory fields:
i) transcript_id - transcript ID;
ii) start        - start coordinate of open reading frame
                   in a transcript;
iii) end         - end coordinate of open reading frame in a transcript.}

\item{tr}{character string giving the name of file with transcript(-s)
of interest. This file must include the transcript(-s) for which the
open reading frame(-s) was/were identified and listed in above orfs
file. Valid formats are "gtf", "gff", "fasta" and "fa".}

\item{genome}{character string giving the name of BSgenome data package with
full genome sequences. Default value is "BSgenome.Hsapiens.UCSC.hg38".}

\item{workDir}{character string giving the path to and name of work
directory. NULL by default that mean the current working directory.}
}
\value{
DNAStringSet object with sequences of extracted open reading frames.
}
\description{
Extract the sequences of identified open reading frames.
}
\examples{
orfs_path <- system.file("extdata",
                         "Set.trans_ORFs.coordinates.txt",
                         package = "ORFhunteR")
tr_path <- system.file("extdata",
                       "Set.trans_sequences.fasta",
                       package = "ORFhunteR")
seq_orfs <- getSeqORFs(orfs = orfs_path,
                       tr = tr_path,
                       genome = "BSgenome.Hsapiens.UCSC.hg38",
                       workDir = NULL)
}
\author{
Vasily V. Grinev
}
