% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadTrExper.r
\name{loadTrExper}
\alias{loadTrExper}
\title{Load a set of transcripts}
\usage{
loadTrExper(tr, genome = "BSgenome.Hsapiens.UCSC.hg38", workDir = NULL)
}
\arguments{
\item{tr}{character string giving the name of file with experimental
transcripts. Allowed file formats are "fasta", "fa", "gtf" or "gff".}

\item{genome}{character string giving the name of BSgenome data package with
full genome sequences. Default value is "BSgenome.Hsapiens.UCSC.hg38".}

\item{workDir}{character string giving the path to and name of work
directory. NULL by default that mean the current working directory.}
}
\value{
List of loaded transcript sequences.
}
\description{
Load a set of experimental transcripts.
}
\examples{
trans <- system.file("extdata",
                     "Set.trans_sequences.fasta",
                     package = "ORFhunteR")
trans_seq <- loadTrExper(tr = trans)
}
\author{
Vasily V. Grinev
}
