% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imports.R
\name{import.ofst}
\alias{import.ofst}
\title{Load GRanges / GAlignments object from .ofst}
\usage{
import.ofst(file, strandMode = 0, seqinfo = NULL)
}
\arguments{
\item{file}{a path to a .ofst file}

\item{strandMode}{numeric, default 0. Only used for paired end bam files.
One of (0: strand = *, 1: first read of pair is +, 2: first read of pair is -).
See ?strandMode. Note: Sets default to 0 instead of 1, as readGAlignmentPairs uses 1.
This is to guarantee hits, but will also make mismatches of overlapping
transcripts in opposite directions.}

\item{seqinfo}{Seqinfo object, defaul NULL (created from ranges).
Add to avoid warnings later on differences in seqinfo.}
}
\value{
a GAlignment, GAlignmentPairs or GRanges object,
dependent of if cigar/cigar1 is defined in .ofst file.
}
\description{
A much faster way to store, load and use bam files.\cr
.ofst is ORFik fast serialized object,
an optimized format for coverage reads with
cigar and replicate number. It uses the fst format as back-end:
\code{\link{fst-package}}.\cr A .ofst ribo seq file can compress the
information in a bam file from 5GB down to a few MB. This new files has
super fast reading time, only a few seconds, instead of minutes. It also has
random index access possibility of the file. \cr
.ofst is represented as a data.frane format with minimum 4 columns:\cr
1. chromosome\cr  2. start (left most position) \cr 3. strand (+, -, *)\cr
4. width (not added if cigar exists)\cr
5. cigar (not needed if width exists):
 (cigar # M's, match/mismatch total) \cr
5. score: duplicates of that read\cr
6. size: qwidth according to reference of read\cr\cr
If file is from \code{\link{GAlignmentPairs}},
it will contain a cigar1, cigar2 instead
of cigar and start1 and start2 instead of start
}
\details{
Other columns can be named whatever you want and added to meta columns.
Positions are 1-based, not 0-based as .bed.
Import with import.ofst
}
\examples{
## GRanges
gr <- GRanges("1:1-3:-")
tmp <- file.path(tempdir(), "path.ofst")
# export.ofst(gr, file = tmp)
# import.ofst(tmp)
## GAlignment
# Make input data.frame
df <- data.frame(seqnames = "1", cigar = "3M", start = 1L, strand = "+")
ga <- ORFik:::getGAlignments(df)
# export.ofst(ga, file = tmp)
# import.ofst(tmp)
}
