% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grl_helpers.R
\name{sortPerGroup}
\alias{sortPerGroup}
\title{Sort a GRangesList}
\usage{
sortPerGroup(grl, ignore.strand = FALSE, quick.rev = FALSE)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}}}

\item{ignore.strand}{a boolean, (default FALSE): should minus strands be
sorted from highest to lowest ends. If TRUE: from lowest to highest ends.}

\item{quick.rev}{default: FALSE, if TRUE, given that you know all ranges are
sorted from min to max for both strands, it will only reverse coordinates for
minus strand groups, and only if they are in increasing order. Much quicker}
}
\value{
an equally named GRangesList, where each group is
 sorted within group.
}
\description{
A faster, more versatile reimplementation of
\code{\link{sort.GenomicRanges}} for GRangesList,
needed since the original works poorly for more than 10k groups.
This function sorts each group, where "+" strands are
increasing by starts and "-" strands are decreasing by ends.
}
\details{
Note: will not work if groups have equal names.
}
\examples{
gr_plus <- GRanges(seqnames = c("chr1", "chr1"),
                   ranges = IRanges(c(14, 7), width = 3),
                   strand = c("+", "+"))
gr_minus <- GRanges(seqnames = c("chr2", "chr2"),
                    ranges = IRanges(c(1, 4), c(3, 9)),
                    strand = c("-", "-"))
grl <- GRangesList(tx1 = gr_plus, tx2 = gr_minus)
sortPerGroup(grl)

}
