% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/experiment_plots.R
\name{transcriptWindow}
\alias{transcriptWindow}
\title{Make 100 bases size meta window for all libraries in experiment}
\usage{
transcriptWindow(
  leaders,
  cds,
  trailers,
  df,
  outdir = NULL,
  scores = c("sum", "transcriptNormalized"),
  allTogether = TRUE,
  colors = experiment.colors(df),
  title = "Coverage metaplot",
  windowSize = min(min(c(wanted_window_size, widthPerGroup(leaders, FALSE))),
    min(c(wanted_window_size, widthPerGroup(cds, FALSE))), min(c(wanted_window_size,
    widthPerGroup(trailers, FALSE)))),
  wanted_window_size = 100,
  returnPlot = is.null(outdir),
  dfr = NULL,
  idName = "",
  plot.ext = ".pdf",
  type = "ofst",
  is.sorted = FALSE,
  drop.zero.dt = TRUE,
  verbose = TRUE,
  force = TRUE,
  library.names = bamVarName(df),
  BPPARAM = bpparam()
)
}
\arguments{
\item{leaders}{a \code{\link{GRangesList}} of leaders (5' UTRs)}

\item{cds}{a \code{\link{GRangesList}} of coding sequences}

\item{trailers}{a \code{\link{GRangesList}} of trailers (3' UTRs)}

\item{df}{an ORFik \code{\link{experiment}}}

\item{outdir}{directory to save to (default: NULL, no saving)}

\item{scores}{scoring function (default: c("sum", "transcriptNormalized")),
see ?coverageScorings for possible scores.}

\item{allTogether}{plot all coverage plots in 1 output? (defualt: TRUE)}

\item{colors}{Which colors to use, default auto color from function
\code{\link{experiment.colors}}, new color per library type.
Else assign colors yourself.}

\item{title}{title of ggplot}

\item{windowSize}{size of binned windows, minimum of 'wanted_window_size' and
minimum of ranges given. Will inform you if windowSize is < wanted_window_size.}

\item{wanted_window_size}{numeric, default 100. The wanted window size to bin on.}

\item{returnPlot}{return plot from function, default is.null(outdir),
so TRUE if outdir is not defined.}

\item{dfr}{an ORFik \code{\link{experiment}} of RNA-seq to
normalize against. Will add RNA normalized to plot name if this is done.}

\item{idName}{A character ID to add to saved name of plot,
if you make several plots in the same folder,
and same experiment, like splitting transcripts in two groups like
targets / nontargets etc. (default: "")}

\item{plot.ext}{character, default: ".pdf". Alternatives: ".png" or ".jpg".}

\item{type}{a character(default: "default"), load files in experiment
or some precomputed variant, like "ofst" or "pshifted".
These are made with ORFik:::convertLibs(),
shiftFootprintsByExperiment(), etc.
Can also be custom user made folders inside the experiments bam folder.
It acts in a recursive manner with priority: If you state "pshifted",
but it does not exist, it checks "ofst". If no .ofst files, it uses
"default", which always must exists.\cr Presets are (folder is relative
to default lib folder, some types fall back to other formats if folder does not exist):\cr
- "default": load the original files for experiment, usually bam.\cr
- "ofst": loads ofst files from the ofst folder, relative to lib folder (falls back to default)\cr
- "pshifted": loads ofst, wig or bigwig from pshifted folder (falls back to ofst, then default)\cr
- "cov": Load covRle objects from cov_RLE folder (fail if not found)\cr
- "covl": Load covRleList objects, from cov_RLE_List folder (fail if not found)\cr
- "bed": Load bed files, from bed folder (falls back to default)\cr
- Other formats must be loaded directly with fimport}

\item{is.sorted}{logical (FALSE), is grl sorted. That is + strand groups in
increasing ranges (1,2,3), and - strand groups in decreasing ranges (3,2,1)}

\item{drop.zero.dt}{logical FALSE, if TRUE and as.data.table is TRUE,
remove all 0 count positions.
This greatly speeds up and most importantly, greatly reduces memory usage.
Will not change any plots, unless 0 positions are used in some sense.
(mean, median, zscore coverage will only scale differently)}

\item{verbose}{logical, default TRUE, message about library output status.}

\item{force}{logical, default TRUE If TRUE, reload library files even if
matching named variables are found in environment used by experiment
 (see \code{\link{envExp}}) A simple way to make
sure correct libraries are always loaded. FALSE is faster if data
is loaded correctly already.}

\item{library.names}{character vector, names of libraries, default:
name_decider(df, naming)}

\item{BPPARAM}{how many cores/threads to use? default: bpparam()}
}
\value{
NULL, or ggplot object if returnPlot is TRUE
}
\description{
Gives you binned meta coverage plots, either saved seperatly or
all in one.
}
\examples{
df <- ORFik.template.experiment()[3,] # Only third library
loadRegions(df) # Load leader, cds and trailers as GRangesList
#transcriptWindow(leaders, cds, trailers, df, outdir = "directory/to/save")
}
\seealso{
Other experiment plots: 
\code{\link{transcriptWindow1}()},
\code{\link{transcriptWindowPer}()}
}
\concept{experiment plots}
