% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ORFs_helpers.R
\name{txNames}
\alias{txNames}
\title{Get transcript names from orf names}
\usage{
txNames(grl, ref = NULL, unique = FALSE)
}
\arguments{
\item{grl}{a \code{\link{GRangesList}} grouped by ORF
, GRanges object or IRanges object.}

\item{ref}{a reference \code{\link{GRangesList}}. The object
you want grl to subset by names. Add to make sure naming is
valid.}

\item{unique}{a boolean, if true unique the names,
used if several orfs map to same transcript and you only
want the unique groups}
}
\value{
a character vector of transcript names,
 without _* naming
}
\description{
Using the ORFik definition of orf name, which is:
example ENSEMBL:\cr
tx name: ENST0909090909090\cr
orf id: _1 (the first of on that tx)\cr
orf_name: ENST0909090909090_1\cr
So therefor txNames("ENST0909090909090_1") = ENST0909090909090\cr
}
\details{
The names must be extracted from a column called names, or the names of the
grl object. If it is already tx names, it returns the input

NOTE! Do not use _123 etc in end of transcript names if it is not ORFs.
Else you will get errors. Just _ will work, but if transcripts are called
ENST_123124124000 etc, it will crash, so substitute "_" with "."
gsub("_", ".", names)
}
\examples{
gr_plus <- GRanges(seqnames = c("chr1", "chr1"),
                   ranges = IRanges(c(7, 14), width = 3),
                   strand = c("+", "+"))
gr_minus <- GRanges(seqnames = c("chr2", "chr2"),
                    ranges = IRanges(c(4, 1), c(9, 3)),
                    strand = c("-", "-"))
grl <- GRangesList(tx1_1 = gr_plus, tx2_1 = gr_minus)
# there are 2 orfs, both the first on each transcript
txNames(grl)

}
\seealso{
Other ORFHelpers: 
\code{\link{defineTrailer}()},
\code{\link{longestORFs}()},
\code{\link{mapToGRanges}()},
\code{\link{orfID}()},
\code{\link{startCodons}()},
\code{\link{startSites}()},
\code{\link{stopCodons}()},
\code{\link{stopSites}()},
\code{\link{uniqueGroups}()},
\code{\link{uniqueOrder}()}
}
\concept{ORFHelpers}
