inittime <- Sys.time()
cat(paste("\n Starting test.Z-magellan at", date(), "\n"))

## About this test. This ain't that important and it is rather fragile. I
## added it as I made minor changes to the MAGELLAN sources and wanted to
## make sure output was identical. But compiler differences apparently
## introduce some strange minor numerical differences.


RNGkind("Mersenne-Twister")
RNGversion("3.6.3")
test_that("Same output from magellan as before changing their C code", {
    set.seed(1)
    r9 <- rfitness(8)
    ## options(digits = 5)
    ## cat("\n r9 \n")
    ## print(summary(r9[, "Fitness"]))
    ## print(var(r9[, "Fitness"]))
    ## cat("\n 10 runif \n")
    ## print(runif(10))
    ## Anything that simulates from Magellan will not respect
    ## R's seed
    null <- capture.output({
        s9s <- Magellan_stats(r9, verbose = TRUE)
        s9l <- Magellan_stats(r9, short = FALSE, verbose = TRUE)
    })
    s9s_compare <- structure(c(ngeno = 256, npeaks = 23, nsinks = 25, gamma = 0.094, gamma. = 0.089, 
                               r.s = 1.814, nchains = 12, nsteps = 26, nori = 21, depth = 2, 
                               magn = 0.361, sign = 0.339, rsign = 0.272, f.1. = 0.382, X.2. = 0.094, 
                               f.3.. = 0.524, mode_f = 1, outD_m = 3.78, outD_v = 5.953, steps_m = 2.561, 
                               reach_m = 31.858, fitG_m = 136.215, opt_i = 7, mProbOpt_0 = 0.019, 
                               opt_i.1 = 17, mProbOpt_1 = 0.022, opt_i.2 = 29, mProbOpt_2 = 0.028, 
                               opt_i.3 = 32, mProbOpt_3 = 0.051, opt_i.4 = 35, mProbOpt_4 = 0.017, 
                               opt_i.5 = 59, mProbOpt_5 = 0.015, opt_i.6 = 66, mProbOpt_6 = 0.129, 
                               opt_i.7 = 75, mProbOpt_7 = 0.166, opt_i.8 = 76, mProbOpt_8 = 0.023, 
                               opt_i.9 = 80, mProbOpt_9 = 0.051, opt_i.10 = 100, mProbOpt_10 = 0.032, 
                               opt_i.11 = 109, mProbOpt_11 = 0.047, opt_i.12 = 117, mProbOpt_12 = 0.016, 
                               opt_i.13 = 118, mProbOpt_13 = 0.104, opt_i.14 = 137, mProbOpt_14 = 0.018, 
                               opt_i.15 = 172, mProbOpt_15 = 0.016, opt_i.16 = 175, mProbOpt_16 = 0.009, 
                               opt_i.17 = 186, mProbOpt_17 = 0.008, opt_i.18 = 213, mProbOpt_18 = 0.018, 
                               opt_i.19 = 230, mProbOpt_19 = 0.152, opt_i.20 = 232, mProbOpt_20 = 0.025, 
                               opt_i.21 = 242, mProbOpt_21 = 0.014, opt_i.22 = 251, mProbOpt_22 = 0.021
                               ))
    ## cat("\n s9s[21] and s9s_compare[21]\n")
    ## print(s9s[21])
    ## print(s9s_compare[21])
    ## cat("\n where they differ\n")
    ## print(which(s9s!=s9s_compare))

    ## cat("\n name of binary\n")
    ## print(OncoSimulR:::fl_statistics_binary())
    
    ## cat("\n s9s\n")
    ## print(s9s)

    ## cat("\n s9s_compare\n")
    ## print(s9s_compare)
    
    s9l_compare <- structure(c("/* FL name */", "   coco", "", "/* Peaks/Sinks */", "   #genotypes: 256", 
                               "   #peaks: 23", "   #sinks: 25", "", "/* Epistasis types */", 
                               "   none:       0.027", "   magnitude:  0.361", "   sign:       0.339", 
                               "   reciprocal: 0.272", "", "/* Roughness / Slope */", "   r/s: 1.814229", 
                               "", "", "/*****************/", "/****  Gamma  ****/", "/*****************/", 
                               "", "/* Gamma Global */", "   gamma[0]:\t1", "   gamma[1]:\t0.093665", 
                               "   gamma[2]:\t0.177807", "   gamma[3]:\t0.076915", "   gamma[4]:\t0.177604", 
                               "   gamma[5]:\t0.056439", "   gamma[6]:\t0.170016", "   gamma[7]:\t0.028146", 
                               "", "", "/* Gamma Locus */", "", "   Gamma(1->):\t0.043746", 
                               "   Gamma(2->):\t0.077618", "   Gamma(3->):\t0.267865", "   Gamma(4->):\t0.001534", 
                               "   Gamma(5->):\t0.221124", "   Gamma(6->):\t0.047696", "   Gamma(7->):\t0.094423", 
                               "   Gamma(8->):\t-0.012033", "", "   Gamma(->1):\t0.048964", 
                               "   Gamma(->2):\t0.101488", "   Gamma(->3):\t0.120639", "   Gamma(->4):\t0.098386", 
                               "   Gamma(->5):\t0.165804", "   Gamma(->6):\t0.042961", "   Gamma(->7):\t0.101460", 
                               "   Gamma(->8):\t0.078489", "", "   Gamma(1->1):\t1.000000", 
                               "   Gamma(1->2):\t-0.019557", "   Gamma(1->3):\t0.150111", "   Gamma(1->4):\t0.031791", 
                               "   Gamma(1->5):\t0.228112", "   Gamma(1->6):\t-0.023370", "   Gamma(1->7):\t-0.078437", 
                               "   Gamma(1->8):\t0.047110", "", "   Gamma(2->1):\t-0.038198", 
                               "   Gamma(2->2):\t1.000000", "   Gamma(2->3):\t0.085122", "   Gamma(2->4):\t0.046205", 
                               "   Gamma(2->5):\t0.128091", "   Gamma(2->6):\t-0.008970", "   Gamma(2->7):\t0.192830", 
                               "   Gamma(2->8):\t0.139384", "", "   Gamma(3->1):\t0.280729", 
                               "   Gamma(3->2):\t0.239629", "   Gamma(3->3):\t1.000000", "   Gamma(3->4):\t0.337495", 
                               "   Gamma(3->5):\t0.250181", "   Gamma(3->6):\t0.223569", "   Gamma(3->7):\t0.259066", 
                               "   Gamma(3->8):\t0.276613", "", "   Gamma(4->1):\t-0.052958", 
                               "   Gamma(4->2):\t-0.018657", "   Gamma(4->3):\t0.148666", "   Gamma(4->4):\t1.000000", 
                               "   Gamma(4->5):\t0.147806", "   Gamma(4->6):\t-0.123604", "   Gamma(4->7):\t0.025148", 
                               "   Gamma(4->8):\t-0.078286", "", "   Gamma(5->1):\t0.276746", 
                               "   Gamma(5->2):\t0.197695", "   Gamma(5->3):\t0.169838", "   Gamma(5->4):\t0.265767", 
                               "   Gamma(5->5):\t1.000000", "   Gamma(5->6):\t0.244772", "   Gamma(5->7):\t0.298130", 
                               "   Gamma(5->8):\t0.093769", "", "   Gamma(6->1):\t-0.014072", 
                               "   Gamma(6->2):\t0.018148", "   Gamma(6->3):\t0.090907", "   Gamma(6->4):\t-0.023783", 
                               "   Gamma(6->5):\t0.201311", "   Gamma(6->6):\t1.000000", "   Gamma(6->7):\t0.051445", 
                               "   Gamma(6->8):\t0.034108", "", "   Gamma(7->1):\t-0.080636", 
                               "   Gamma(7->2):\t0.205706", "   Gamma(7->3):\t0.122730", "   Gamma(7->4):\t0.101782", 
                               "   Gamma(7->5):\t0.249407", "   Gamma(7->6):\t0.040796", "   Gamma(7->7):\t1.000000", 
                               "   Gamma(7->8):\t0.036728", "", "   Gamma(8->1):\t-0.028865", 
                               "   Gamma(8->2):\t0.087450", "   Gamma(8->3):\t0.077099", "   Gamma(8->4):\t-0.070553", 
                               "   Gamma(8->5):\t-0.044282", "   Gamma(8->6):\t-0.052466", "   Gamma(8->7):\t-0.037958", 
                               "   Gamma(8->8):\t1.000000", "", "", "", "/* Gamma Allele Pairs */", 
                               "", "   Gamma(1->1):\t1.000000", "   Gamma(1->2):\t-0.019557", 
                               "   Gamma(1->3):\t0.150111", "   Gamma(1->4):\t0.031791", "   Gamma(1->5):\t0.228112", 
                               "   Gamma(1->6):\t-0.023370", "   Gamma(1->7):\t-0.078437", "   Gamma(1->8):\t0.047110", 
                               "", "   Gamma(2->1):\t-0.038198", "   Gamma(2->2):\t1.000000", 
                               "   Gamma(2->3):\t0.085122", "   Gamma(2->4):\t0.046205", "   Gamma(2->5):\t0.128091", 
                               "   Gamma(2->6):\t-0.008970", "   Gamma(2->7):\t0.192830", "   Gamma(2->8):\t0.139384", 
                               "", "   Gamma(3->1):\t0.280729", "   Gamma(3->2):\t0.239629", 
                               "   Gamma(3->3):\t1.000000", "   Gamma(3->4):\t0.337495", "   Gamma(3->5):\t0.250181", 
                               "   Gamma(3->6):\t0.223569", "   Gamma(3->7):\t0.259066", "   Gamma(3->8):\t0.276613", 
                               "", "   Gamma(4->1):\t-0.052958", "   Gamma(4->2):\t-0.018657", 
                               "   Gamma(4->3):\t0.148666", "   Gamma(4->4):\t1.000000", "   Gamma(4->5):\t0.147806", 
                               "   Gamma(4->6):\t-0.123604", "   Gamma(4->7):\t0.025148", "   Gamma(4->8):\t-0.078286", 
                               "", "   Gamma(5->1):\t0.276746", "   Gamma(5->2):\t0.197695", 
                               "   Gamma(5->3):\t0.169838", "   Gamma(5->4):\t0.265767", "   Gamma(5->5):\t1.000000", 
                               "   Gamma(5->6):\t0.244772", "   Gamma(5->7):\t0.298130", "   Gamma(5->8):\t0.093769", 
                               "", "   Gamma(6->1):\t-0.014072", "   Gamma(6->2):\t0.018148", 
                               "   Gamma(6->3):\t0.090907", "   Gamma(6->4):\t-0.023783", "   Gamma(6->5):\t0.201311", 
                               "   Gamma(6->6):\t1.000000", "   Gamma(6->7):\t0.051445", "   Gamma(6->8):\t0.034108", 
                               "", "   Gamma(7->1):\t-0.080636", "   Gamma(7->2):\t0.205706", 
                               "   Gamma(7->3):\t0.122730", "   Gamma(7->4):\t0.101782", "   Gamma(7->5):\t0.249407", 
                               "   Gamma(7->6):\t0.040796", "   Gamma(7->7):\t1.000000", "   Gamma(7->8):\t0.036728", 
                               "", "   Gamma(8->1):\t-0.028865", "   Gamma(8->2):\t0.087450", 
                               "   Gamma(8->3):\t0.077099", "   Gamma(8->4):\t-0.070553", "   Gamma(8->5):\t-0.044282", 
                               "   Gamma(8->6):\t-0.052466", "   Gamma(8->7):\t-0.037958", "   Gamma(8->8):\t1.000000", 
                               "", "", "   Gamma(->1):\t0.048964", "   Gamma(->2):\t0.101488", 
                               "   Gamma(->3):\t0.120639", "   Gamma(->4):\t0.098386", "   Gamma(->5):\t0.165804", 
                               "   Gamma(->6):\t0.042961", "   Gamma(->7):\t0.101460", "   Gamma(->8):\t0.078489", 
                               "", "   Gamma(1->):\t0.043746", "   Gamma(2->):\t0.077618", "   Gamma(3->):\t0.267865", 
                               "   Gamma(4->):\t0.001534", "   Gamma(5->):\t0.221124", "   Gamma(6->):\t0.047696", 
                               "   Gamma(7->):\t0.094423", "   Gamma(8->):\t-0.012033", "", 
                               "", "/* Gamma Allele */", "", "   Gamma(1->1):\t1.000000", "   Gamma(1->2):\t1.000000", 
                               "   Gamma(1->3):\t-0.019557", "   Gamma(1->4):\t-0.019557", "   Gamma(1->5):\t0.150111", 
                               "   Gamma(1->6):\t0.150111", "   Gamma(1->7):\t0.031791", "   Gamma(1->8):\t0.031791", 
                               "   Gamma(1->9):\t0.228112", "   Gamma(1->10):\t0.228112", "   Gamma(1->11):\t-0.023370", 
                               "   Gamma(1->12):\t-0.023370", "   Gamma(1->13):\t-0.078437", 
                               "   Gamma(1->14):\t-0.078437", "   Gamma(1->15):\t0.047110", 
                               "   Gamma(1->16):\t0.047110", "", "   Gamma(2->1):\t1.000000", 
                               "   Gamma(2->2):\t1.000000", "   Gamma(2->3):\t-0.019557", "   Gamma(2->4):\t-0.019557", 
                               "   Gamma(2->5):\t0.150111", "   Gamma(2->6):\t0.150111", "   Gamma(2->7):\t0.031791", 
                               "   Gamma(2->8):\t0.031791", "   Gamma(2->9):\t0.228112", "   Gamma(2->10):\t0.228112", 
                               "   Gamma(2->11):\t-0.023370", "   Gamma(2->12):\t-0.023370", 
                               "   Gamma(2->13):\t-0.078437", "   Gamma(2->14):\t-0.078437", 
                               "   Gamma(2->15):\t0.047110", "   Gamma(2->16):\t0.047110", "", 
                               "   Gamma(3->1):\t-0.038198", "   Gamma(3->2):\t-0.038198", "   Gamma(3->3):\t1.000000", 
                               "   Gamma(3->4):\t1.000000", "   Gamma(3->5):\t0.085122", "   Gamma(3->6):\t0.085122", 
                               "   Gamma(3->7):\t0.046205", "   Gamma(3->8):\t0.046205", "   Gamma(3->9):\t0.128091", 
                               "   Gamma(3->10):\t0.128091", "   Gamma(3->11):\t-0.008970", 
                               "   Gamma(3->12):\t-0.008970", "   Gamma(3->13):\t0.192830", 
                               "   Gamma(3->14):\t0.192830", "   Gamma(3->15):\t0.139384", "   Gamma(3->16):\t0.139384", 
                               "", "   Gamma(4->1):\t-0.038198", "   Gamma(4->2):\t-0.038198", 
                               "   Gamma(4->3):\t1.000000", "   Gamma(4->4):\t1.000000", "   Gamma(4->5):\t0.085122", 
                               "   Gamma(4->6):\t0.085122", "   Gamma(4->7):\t0.046205", "   Gamma(4->8):\t0.046205", 
                               "   Gamma(4->9):\t0.128091", "   Gamma(4->10):\t0.128091", "   Gamma(4->11):\t-0.008970", 
                               "   Gamma(4->12):\t-0.008970", "   Gamma(4->13):\t0.192830", 
                               "   Gamma(4->14):\t0.192830", "   Gamma(4->15):\t0.139384", "   Gamma(4->16):\t0.139384", 
                               "", "   Gamma(5->1):\t0.280729", "   Gamma(5->2):\t0.280729", 
                               "   Gamma(5->3):\t0.239629", "   Gamma(5->4):\t0.239629", "   Gamma(5->5):\t1.000000", 
                               "   Gamma(5->6):\t1.000000", "   Gamma(5->7):\t0.337495", "   Gamma(5->8):\t0.337495", 
                               "   Gamma(5->9):\t0.250181", "   Gamma(5->10):\t0.250181", "   Gamma(5->11):\t0.223569", 
                               "   Gamma(5->12):\t0.223569", "   Gamma(5->13):\t0.259066", "   Gamma(5->14):\t0.259066", 
                               "   Gamma(5->15):\t0.276613", "   Gamma(5->16):\t0.276613", "", 
                               "   Gamma(6->1):\t0.280729", "   Gamma(6->2):\t0.280729", "   Gamma(6->3):\t0.239629", 
                               "   Gamma(6->4):\t0.239629", "   Gamma(6->5):\t1.000000", "   Gamma(6->6):\t1.000000", 
                               "   Gamma(6->7):\t0.337495", "   Gamma(6->8):\t0.337495", "   Gamma(6->9):\t0.250181", 
                               "   Gamma(6->10):\t0.250181", "   Gamma(6->11):\t0.223569", "   Gamma(6->12):\t0.223569", 
                               "   Gamma(6->13):\t0.259066", "   Gamma(6->14):\t0.259066", "   Gamma(6->15):\t0.276613", 
                               "   Gamma(6->16):\t0.276613", "", "   Gamma(7->1):\t-0.052958", 
                               "   Gamma(7->2):\t-0.052958", "   Gamma(7->3):\t-0.018657", "   Gamma(7->4):\t-0.018657", 
                               "   Gamma(7->5):\t0.148666", "   Gamma(7->6):\t0.148666", "   Gamma(7->7):\t1.000000", 
                               "   Gamma(7->8):\t1.000000", "   Gamma(7->9):\t0.147806", "   Gamma(7->10):\t0.147806", 
                               "   Gamma(7->11):\t-0.123604", "   Gamma(7->12):\t-0.123604", 
                               "   Gamma(7->13):\t0.025148", "   Gamma(7->14):\t0.025148", "   Gamma(7->15):\t-0.078286", 
                               "   Gamma(7->16):\t-0.078286", "", "   Gamma(8->1):\t-0.052958", 
                               "   Gamma(8->2):\t-0.052958", "   Gamma(8->3):\t-0.018657", "   Gamma(8->4):\t-0.018657", 
                               "   Gamma(8->5):\t0.148666", "   Gamma(8->6):\t0.148666", "   Gamma(8->7):\t1.000000", 
                               "   Gamma(8->8):\t1.000000", "   Gamma(8->9):\t0.147806", "   Gamma(8->10):\t0.147806", 
                               "   Gamma(8->11):\t-0.123604", "   Gamma(8->12):\t-0.123604", 
                               "   Gamma(8->13):\t0.025148", "   Gamma(8->14):\t0.025148", "   Gamma(8->15):\t-0.078286", 
                               "   Gamma(8->16):\t-0.078286", "", "   Gamma(9->1):\t0.276746", 
                               "   Gamma(9->2):\t0.276746", "   Gamma(9->3):\t0.197695", "   Gamma(9->4):\t0.197695", 
                               "   Gamma(9->5):\t0.169838", "   Gamma(9->6):\t0.169838", "   Gamma(9->7):\t0.265767", 
                               "   Gamma(9->8):\t0.265767", "   Gamma(9->9):\t1.000000", "   Gamma(9->10):\t1.000000", 
                               "   Gamma(9->11):\t0.244772", "   Gamma(9->12):\t0.244772", "   Gamma(9->13):\t0.298130", 
                               "   Gamma(9->14):\t0.298130", "   Gamma(9->15):\t0.093769", "   Gamma(9->16):\t0.093769", 
                               "", "   Gamma(10->1):\t0.276746", "   Gamma(10->2):\t0.276746", 
                               "   Gamma(10->3):\t0.197695", "   Gamma(10->4):\t0.197695", "   Gamma(10->5):\t0.169838", 
                               "   Gamma(10->6):\t0.169838", "   Gamma(10->7):\t0.265767", "   Gamma(10->8):\t0.265767", 
                               "   Gamma(10->9):\t1.000000", "   Gamma(10->10):\t1.000000", 
                               "   Gamma(10->11):\t0.244772", "   Gamma(10->12):\t0.244772", 
                               "   Gamma(10->13):\t0.298130", "   Gamma(10->14):\t0.298130", 
                               "   Gamma(10->15):\t0.093769", "   Gamma(10->16):\t0.093769", 
                               "", "   Gamma(11->1):\t-0.014072", "   Gamma(11->2):\t-0.014072", 
                               "   Gamma(11->3):\t0.018148", "   Gamma(11->4):\t0.018148", "   Gamma(11->5):\t0.090907", 
                               "   Gamma(11->6):\t0.090907", "   Gamma(11->7):\t-0.023783", 
                               "   Gamma(11->8):\t-0.023783", "   Gamma(11->9):\t0.201311", 
                               "   Gamma(11->10):\t0.201311", "   Gamma(11->11):\t1.000000", 
                               "   Gamma(11->12):\t1.000000", "   Gamma(11->13):\t0.051445", 
                               "   Gamma(11->14):\t0.051445", "   Gamma(11->15):\t0.034108", 
                               "   Gamma(11->16):\t0.034108", "", "   Gamma(12->1):\t-0.014072", 
                               "   Gamma(12->2):\t-0.014072", "   Gamma(12->3):\t0.018148", 
                               "   Gamma(12->4):\t0.018148", "   Gamma(12->5):\t0.090907", "   Gamma(12->6):\t0.090907", 
                               "   Gamma(12->7):\t-0.023783", "   Gamma(12->8):\t-0.023783", 
                               "   Gamma(12->9):\t0.201311", "   Gamma(12->10):\t0.201311", 
                               "   Gamma(12->11):\t1.000000", "   Gamma(12->12):\t1.000000", 
                               "   Gamma(12->13):\t0.051445", "   Gamma(12->14):\t0.051445", 
                               "   Gamma(12->15):\t0.034108", "   Gamma(12->16):\t0.034108", 
                               "", "   Gamma(13->1):\t-0.080636", "   Gamma(13->2):\t-0.080636", 
                               "   Gamma(13->3):\t0.205706", "   Gamma(13->4):\t0.205706", "   Gamma(13->5):\t0.122730", 
                               "   Gamma(13->6):\t0.122730", "   Gamma(13->7):\t0.101782", "   Gamma(13->8):\t0.101782", 
                               "   Gamma(13->9):\t0.249407", "   Gamma(13->10):\t0.249407", 
                               "   Gamma(13->11):\t0.040796", "   Gamma(13->12):\t0.040796", 
                               "   Gamma(13->13):\t1.000000", "   Gamma(13->14):\t1.000000", 
                               "   Gamma(13->15):\t0.036728", "   Gamma(13->16):\t0.036728", 
                               "", "   Gamma(14->1):\t-0.080636", "   Gamma(14->2):\t-0.080636", 
                               "   Gamma(14->3):\t0.205706", "   Gamma(14->4):\t0.205706", "   Gamma(14->5):\t0.122730", 
                               "   Gamma(14->6):\t0.122730", "   Gamma(14->7):\t0.101782", "   Gamma(14->8):\t0.101782", 
                               "   Gamma(14->9):\t0.249407", "   Gamma(14->10):\t0.249407", 
                               "   Gamma(14->11):\t0.040796", "   Gamma(14->12):\t0.040796", 
                               "   Gamma(14->13):\t1.000000", "   Gamma(14->14):\t1.000000", 
                               "   Gamma(14->15):\t0.036728", "   Gamma(14->16):\t0.036728", 
                               "", "   Gamma(15->1):\t-0.028865", "   Gamma(15->2):\t-0.028865", 
                               "   Gamma(15->3):\t0.087450", "   Gamma(15->4):\t0.087450", "   Gamma(15->5):\t0.077099", 
                               "   Gamma(15->6):\t0.077099", "   Gamma(15->7):\t-0.070553", 
                               "   Gamma(15->8):\t-0.070553", "   Gamma(15->9):\t-0.044282", 
                               "   Gamma(15->10):\t-0.044282", "   Gamma(15->11):\t-0.052466", 
                               "   Gamma(15->12):\t-0.052466", "   Gamma(15->13):\t-0.037958", 
                               "   Gamma(15->14):\t-0.037958", "   Gamma(15->15):\t1.000000", 
                               "   Gamma(15->16):\t1.000000", "", "   Gamma(16->1):\t-0.028865", 
                               "   Gamma(16->2):\t-0.028865", "   Gamma(16->3):\t0.087450", 
                               "   Gamma(16->4):\t0.087450", "   Gamma(16->5):\t0.077099", "   Gamma(16->6):\t0.077099", 
                               "   Gamma(16->7):\t-0.070553", "   Gamma(16->8):\t-0.070553", 
                               "   Gamma(16->9):\t-0.044282", "   Gamma(16->10):\t-0.044282", 
                               "   Gamma(16->11):\t-0.052466", "   Gamma(16->12):\t-0.052466", 
                               "   Gamma(16->13):\t-0.037958", "   Gamma(16->14):\t-0.037958", 
                               "   Gamma(16->15):\t1.000000", "   Gamma(16->16):\t1.000000", 
                               "", "", "   Gamma(->1):\t0.048964", "   Gamma(->2):\t0.048964", 
                               "   Gamma(->3):\t0.101488", "   Gamma(->4):\t0.101488", "   Gamma(->5):\t0.120639", 
                               "   Gamma(->6):\t0.120639", "   Gamma(->7):\t0.098386", "   Gamma(->8):\t0.098386", 
                               "   Gamma(->9):\t0.165804", "   Gamma(->10):\t0.165804", "   Gamma(->11):\t0.042961", 
                               "   Gamma(->12):\t0.042961", "   Gamma(->13):\t0.101460", "   Gamma(->14):\t0.101460", 
                               "   Gamma(->15):\t0.078489", "   Gamma(->16):\t0.078489", "", 
                               "   Gamma(1->):\t0.043746", "   Gamma(2->):\t0.043746", "   Gamma(3->):\t0.077618", 
                               "   Gamma(4->):\t0.077618", "   Gamma(5->):\t0.267865", "   Gamma(6->):\t0.267865", 
                               "   Gamma(7->):\t0.001534", "   Gamma(8->):\t0.001534", "   Gamma(9->):\t0.221124", 
                               "   Gamma(10->):\t0.221124", "   Gamma(11->):\t0.047696", "   Gamma(12->):\t0.047696", 
                               "   Gamma(13->):\t0.094423", "   Gamma(14->):\t0.094423", "   Gamma(15->):\t-0.012033", 
                               "   Gamma(16->):\t-0.012033", "", "", "/* Fourier Decomposition */", 
                               "   o\tfraction", "   1\t0.382", "   2\t0.094", "   3\t0.125", 
                               "   4\t0.167", "   5\t0.132", "   6\t0.066", "   7\t0.012", "   8\t0.022", 
                               "", "/* Fourier Fraction epistasis */", "\t0.618", "", "/* Out-degree distribution */", 
                               "   deg #   fract", "d:  0   23 0.090", "d:  1   26 0.102", "d:  2   25 0.098", 
                               "d:  3   40 0.156", "d:  4   37 0.145", "d:  5   28 0.109", "d:  6   24 0.094", 
                               "d:  7   28 0.109", "d:  8   25 0.098", "Mean(OutDegree):  4.000000", 
                               "Stdev(OutDegree): 5.952941", "", "/* Accessible genotypes from g after (s steps) */", 
                               "   g\ts1   s2   s3 ...", "----\t----------------", "   0\t 1    1    3    4    5    6    6 ", 
                               "   1\t 1    6   12   19   24   24   23   22   21   21 ", "   2\t 1    7   17   39   59   79   83   82   85   81   80   77   76   74   74 ", 
                               "   3\t 1    1    1 ", "   4\t 1    7   13   23   36   44   42   41   39   38   38 ", 
                               "   5\t 1    4    7    8    9   10   10   10 ", "   6\t 1    1 ", 
                               "   7\t 1    8   18   34   48   57   66   72   76   74   69   67   66   66 ", 
                               "   8\t 1    3    4    5    6    6 ", "   9\t 1    4    9   12   15   17   17   17   16   16 ", 
                               "   10\t 1    5   15   27   41   54   63   70   65   65   64   65   65   65 ", 
                               "   11\t 1    7   17   35   52   69   81   78   83   78   72   72   72   72 ", 
                               "   12\t 1    5   13   25   32   33   35   33   30   29   28   28 ", 
                               "   13\t 1    2    3    4    5    5    5    5 ", "   14\t 1    6   12   19   29   36   37   37   35   32   31   30   30 ", 
                               "   15\t 1    6   13   20   29   36   42   42   42   40   37   37 ", 
                               "   16\t 1    5   11   19   24   30   31   33   33   31   30   30 ", 
                               "   17\t 1    8   22   34   48   53   59   66   64   63   61   62   62   62 ", 
                               "   18\t 1    5   18   32   54   64   68   72   74   72   68   67   67 ", 
                               "   19\t 1    6   13   25   30   35   45   53   52   52   52   51   51 ", 
                               "   20\t 1    3    6    7    8    8    8 ", "   21\t 1    3    4    5    5    5 ", 
                               "   22\t 1    7   19   44   62   80   83   85   86   83   79   79   79 ", 
                               "   23\t 1    2    4    5    6    6    6 ", "   24\t 1    1 ", 
                               "   25\t 1    4    6    9   11   13   13   11   10   10 ", "   26\t 1    6   14   25   35   49   58   60   59   58   59   59   59 ", 
                               "   27\t 1    4   11   16   29   38   44   47   47   43   40   40   40 ", 
                               "   28\t 1    3    3    3 ", "   29\t 1    8   21   29   35   31   28   28 ", 
                               "   30\t 1    1 ", "   31\t 1    5    5    8    7    7    7    7 ", 
                               "   32\t 1    8   20   39   49   59   58   59   55   54   53   52   52 ", 
                               "   33\t 1    3    6    8    9   10   10   10 ", "   34\t 1    4   15   23   29   31   27   25   24   22   21   21 ", 
                               "   35\t 1    8   16   33   41   45   46   47   45   44   44 ", 
                               "   36\t 1    5   10   15   20   18   17   17   17 ", "   37\t 1    2    3    3    3    3 ", 
                               "   38\t 1    5    9   12   12   14   13   12   12 ", "   39\t 1    4    7    9   11   11   10    9    9 ", 
                               "   40\t 1    2    4    5    5 ", "   41\t 1    3    5    8    9    9    8    8 ", 
                               "   42\t 1    5    6    8    9    9    9 ", "   43\t 1    4   11   18   26   24   22   20   18   17   17 ", 
                               "   44\t 1    4    8   12   12   12   12 ", "   45\t 1    2    3    4    4    4    4 ", 
                               "   46\t 1    3    5    5    5    5 ", "   47\t 1    3    6    9   10   10    9    9 ", 
                               "   48\t 1    4    7   10   10    9    9 ", "   49\t 1    2    3    3    3    3 ", 
                               "   50\t 1    5    9   17   21   21   19   19   18   18 ", "   51\t 1    2    3    4    4    4    4 ", 
                               "   52\t 1    1    1    1 ", "   53\t 1    2    2    2    2 ", 
                               "   54\t 1    4   10   14   13   12   14   13   12   12 ", "   55\t 1    1    1 ", 
                               "   56\t 1    2    2    2 ", "   57\t 1    4    8   10   12   12   10    9    9 ", 
                               "   58\t 1    2    4    4    4    4 ", "   59\t 1    8   20   39   54   58   64   62   57   55   54   54   54 ", 
                               "   60\t 1    1    1 ", "   61\t 1    6   12   14   14   11   12   12 ", 
                               "   62\t 1    3    3    3    3 ", "   63\t 1    1    1    1 ", 
                               "   64\t 1    1    1    3    4    5    6    6 ", "   65\t 1    6   20   32   49   62   67   65   63   62   61   61 ", 
                               "   66\t 1    8   24   46   78  105  120  123  121  120  116  113  111  110  110 ", 
                               "   67\t 1    6   17   42   60   79   94   95   95   87   82   76   75   74   74 ", 
                               "   68\t 1    5   15   22   34   44   53   50   48   47   46   46 ", 
                               "   69\t 1    4    7   10   13   19   20   22   22   22 ", "   70\t 1    5   11   27   41   56   66   76   80   80   78   76   76 ", 
                               "   71\t 1    4   14   26   36   44   53   60   62   59   59   58   58 ", 
                               "   72\t 1    6   17   29   47   65   77   89   84   86   81   77   74   72   72 ", 
                               "   73\t 1    7   19   40   57   75   91   96   99   96   96   93   92   92 ", 
                               "   74\t 1    5   13   27   42   56   72   76   81   74   69   65   64   64   64 ", 
                               "   75\t 1    8   27   55   88  118  133  135  128  129  127  121  119  117  117 ", 
                               "   76\t 1    8   21   40   62   81   90   96  103   98  100   96   93   93 ", 
                               "   77\t 1    1 ", "   78\t 1    1    1 ", "   79\t 1    3    3    3 ", 
                               "   80\t 1    8   24   42   70   84   98  104  102   98   95   90   89   89 ", 
                               "   81\t 1    2    2 ", "   82\t 1    5   12   33   50   66   79   80   82   77   74   71   70   70 ", 
                               "   83\t 1    3    9   14   22   33   43   46   48   47   47   47 ", 
                               "   84\t 1    5    8   14   15   20   21   19   19   18   18 ", 
                               "   85\t 1    1 ", "   86\t 1    7   24   48   78   97  105  107  101   96   92   88   87   87 ", 
                               "   87\t 1    6    9   15   18   25   36   45   47   48   47   47   47 ", 
                               "   88\t 1    5    5    5    5    5 ", "   89\t 1    1 ", "   90\t 1    5   15   24   37   49   55   57   57   58   58   58 ", 
                               "   91\t 1    4    7   16   27   38   43   47   43   40   40   40 ", 
                               "   92\t 1    1    3    3    3 ", "   93\t 1    6    8   16   19   19   19   18   18 ", 
                               "   94\t 1    5    8   17   24   29   30   27   25   25 ", "   95\t 1    1 ", 
                               "   96\t 1    3    7   10   22   26   33   34   35   33   32   32 ", 
                               "   97\t 1    7   12   25   33   44   46   48   46   45   45 ", 
                               "   98\t 1    7   13   25   35   48   50   51   52   50   48   47   47 ", 
                               "   99\t 1    1    4    6    9   11   16   15   17   17 ", "   100\t 1    8   21   39   51   68   71   71   67   64   63   62   62 ", 
                               "   101\t 1    2    5    8   18   20   20   18   18   18 ", "   102\t 1    1    1 ", 
                               "   103\t 1    7   15   32   46   55   59   62   67   68   65   65   64   64 ", 
                               "   104\t 1    4    7   17   20   25   28   31   29   27   26   26 ", 
                               "   105\t 1    3   12   15   22   26   29   27   25   23   23 ", 
                               "   106\t 1    1    1 ", "   107\t 1    7   16   36   54   69   76   78   79   78   80   81   81   80   80 ", 
                               "   108\t 1    5   13   19   30   30   33   34   36   34   34   34 ", 
                               "   109\t 1    8   21   44   64   75   79   77   79   81   85   84   84   83   83 ", 
                               "   110\t 1    1 ", "   111\t 1    6   18   32   55   68   73   74   75   80   80   80   79   78   78 ", 
                               "   112\t 1    7   16   32   38   52   54   54   52   51   49   48   48 ", 
                               "   113\t 1    3    7   10   16   16   16   15   15 ", "   114\t 1    3   11   16   26   30   32   29   31   30   30 ", 
                               "   115\t 1    4    6    9   11   16   15   17   17 ", "   116\t 1    2    2    2    2 ", 
                               "   117\t 1    8   17   32   34   38   36   35   33   33 ", "   118\t 1    8   21   48   77   97  111  112  110  104  100   96   92   91   91 ", 
                               "   119\t 1    1    1    1 ", "   120\t 1    1    2    2    2 ", 
                               "   121\t 1    5    8   14   18   21   20   20   19   19 ", "   122\t 1    4    5    7    7    7    7 ", 
                               "   123\t 1    4   15   26   38   43   47   43   40   40   40 ", 
                               "   124\t 1    5    6    7    7 ", "   125\t 1    5   18   26   34   33   30   31   31 ", 
                               "   126\t 1    7   19   29   42   48   52   51   49   48   48 ", 
                               "   127\t 1    5   13   30   37   44   42   40   40   40 ", "   128\t 1    5   10   20   25   30   31   35   35   33   32   32 ", 
                               "   129\t 1    3    6    6    6    6 ", "   130\t 1    6   17   25   39   48   51   51   50   49   46   44   42   42 ", 
                               "   131\t 1    1 ", "   132\t 1    1    1    1    1 ", "   133\t 1    3    3    4    4    4 ", 
                               "   134\t 1    7   19   40   56   75   78   76   71   67   65   65 ", 
                               "   135\t 1    4    6    6    7    7    7 ", "   136\t 1    2    3    4    4 ", 
                               "   137\t 1    8   18   28   30   31   32   31   30   29   29 ", 
                               "   138\t 1    1    1 ", "   139\t 1    5   11   14   18   16   15   14   13   13   13 ", 
                               "   140\t 1    5   14   25   27   30   30   27   26   25   25 ", 
                               "   141\t 1    6   12   14   15   16   15   14   14 ", "   142\t 1    4    8   16   27   30   32   31   28   27   26   26 ", 
                               "   143\t 1    1    1    2    2    1    1 ", "   144\t 1    4   13   19   27   29   33   33   31   30   30 ", 
                               "   145\t 1    2    2    2 ", "   146\t 1    5   10   22   30   36   36   38   35   33   32   32 ", 
                               "   147\t 1    4   10   11   10   10   10   10   10 ", "   148\t 1    5   10   20   24   28   27   25   24   24 ", 
                               "   149\t 1    1    2    2    2 ", "   150\t 1    6   23   39   59   63   64   60   56   53   53 ", 
                               "   151\t 1    7   13   17   18   16   15   15   15 ", "   152\t 1    5    8    9    8    8 ", 
                               "   153\t 1    1    1 ", "   154\t 1    3    8   11   12   11   10   10 ", 
                               "   155\t 1    3    3    4    4    3    3 ", "   156\t 1    5   15   19   26   26   23   22   21   21 ", 
                               "   157\t 1    4    7    8    8    7    7 ", "   158\t 1    7   17   33   39   40   38   35   33   32   32 ", 
                               "   159\t 1    1    2    2    1    1 ", "   160\t 1    7   16   26   34   37   40   38   40   38   37   37 ", 
                               "   161\t 1    7   12   19   21   24   23   24   24 ", "   162\t 1    5    8   10   11   12   11   11   11   11 ", 
                               "   163\t 1    3    7    8    8    8    8    8    8 ", "   164\t 1    1    1    1 ", 
                               "   165\t 1    1    1 ", "   166\t 1    3    3    3    3 ", "   167\t 1    2    2    2 ", 
                               "   168\t 1    2    3    3 ", "   169\t 1    2    2 ", "   170\t 1    1 ", 
                               "   171\t 1    5    9   15   14   13   12   11   11   11 ", "   172\t 1    8   17   23   33   34   37   36   34   33   33 ", 
                               "   173\t 1    1 ", "   174\t 1    1    1 ", "   175\t 1    8   14   18   25   25   25   24   24   24 ", 
                               "   176\t 1    3    6    8    7    7 ", "   177\t 1    1    1 ", 
                               "   178\t 1    1 ", "   179\t 1    5    6    6    6    6    6    6 ", 
                               "   180\t 1    7   15   19   28   30   31   29   27   26   26 ", 
                               "   181\t 1    6    9    8    6    6 ", "   182\t 1    7   15   26   34   36   36   36   33   31   31 ", 
                               "   183\t 1    1 ", "   184\t 1    4    6    5    5 ", "   185\t 1    1 ", 
                               "   186\t 1    8   14   21   21   20   19   19 ", "   187\t 1    4   10   10    9    8    7    7    7 ", 
                               "   188\t 1    1 ", "   189\t 1    4    5    5    4    4 ", "   190\t 1    4    6    5    4    4 ", 
                               "   191\t 1    2    2    1    1 ", "   192\t 1    4    9   15   29   34   38   38   38   37   35   34   34 ", 
                               "   193\t 1    6   14   27   36   48   48   49   49   47   47 ", 
                               "   194\t 1    4    8   16   22   33   40   46   46   44   42   40   40 ", 
                               "   195\t 1    7   23   37   57   72   79   86   83   79   74   73   72   72 ", 
                               "   196\t 1    3    4    7    9   17   17   17   17   16   16 ", 
                               "   197\t 1    5   13   18   25   27   26   25   26   25   25 ", 
                               "   198\t 1    7   24   46   79   96   99   97   94   93   91   89   87   87 ", 
                               "   199\t 1    5   13   25   30   35   35   38   37   38   38 ", 
                               "   200\t 1    6   11   19   25   37   41   43   44   44   42   40   39   39 ", 
                               "   201\t 1    1 ", "   202\t 1    3    8   10   13   16   17   16   15   15 ", 
                               "   203\t 1    6   14   24   28   36   35   34   33   31   30   30 ", 
                               "   204\t 1    1 ", "   205\t 1    3    3 ", "   206\t 1    6   14   27   36   43   44   43   41   38   37   36   36 ", 
                               "   207\t 1    5   11   13   18   20   19   19   19 ", "   208\t 1    7   16   33   41   48   49   49   49   48   47   47 ", 
                               "   209\t 1    4   11   14   21   22   19   18   18 ", "   210\t 1    1    4    6    9   12   13   12   11   11 ", 
                               "   211\t 1    7   13   24   34   44   52   57   55   53   52   52   52 ", 
                               "   212\t 1    2    6    8   16   17   17   17   16   16 ", "   213\t 1    8   16   29   34   37   37   35   34   33   32   32 ", 
                               "   214\t 1    5    8   16   24   35   36   33   31   31 ", "   215\t 1    1 ", 
                               "   216\t 1    1 ", "   217\t 1    7    9   14   16   16   16   15   15 ", 
                               "   218\t 1    4    6    9   12   13   12   11   11 ", "   219\t 1    1 ", 
                               "   220\t 1    5    8   16   17   17   17   16   16 ", "   221\t 1    3   10   13   13   13   12   12 ", 
                               "   222\t 1    4   13   20   28   29   26   24   24 ", "   223\t 1    5    7   15   18   16   16   16 ", 
                               "   224\t 1    2    2    5    7   13   14   15   14   14 ", "   225\t 1    1    4    6   12   13   14   13   13 ", 
                               "   226\t 1    1 ", "   227\t 1    7   11   17   21   27   29   31   32   29   29 ", 
                               "   228\t 1    6   10   11   21   23   29   26   22   21   20   20 ", 
                               "   229\t 1    4    6   16   19   20   18   18   18 ", "   230\t 1    8   20   40   63   93  104  100   97   95   94   92   90   89   89 ", 
                               "   231\t 1    4   10   12   20   22   24   22   22   22 ", "   232\t 1    8   21   31   41   45   55   55   55   50   49   48   47   47 ", 
                               "   233\t 1    6    7   10   12   17   18   16   15   15 ", "   234\t 1    5    5    5 ", 
                               "   235\t 1    1 ", "   236\t 1    3    5    6    6 ", "   237\t 1    2    4    4 ", 
                               "   238\t 1    7   17   27   36   40   44   44   43   41   38   37   36   36 ", 
                               "   239\t 1    2    3    5    5 ", "   240\t 1    5   13   16   23   24   28   26   22   21   21 ", 
                               "   241\t 1    4    6   12   13   14   13   13 ", "   242\t 1    8   13   22   32   43   44   45   43   39   38   38 ", 
                               "   243\t 1    1 ", "   244\t 1    1 ", "   245\t 1    3   10   12   13   11   11 ", 
                               "   246\t 1    1    1 ", "   247\t 1    6    8   13   15   17   15   15 ", 
                               "   248\t 1    6    8   10    9    9 ", "   249\t 1    1    1 ", 
                               "   250\t 1    1 ", "   251\t 1    8   18   32   43   49   50   49   44   41   41   41 ", 
                               "   252\t 1    2    2 ", "   253\t 1    4    7   10   10    9    9 ", 
                               "   254\t 1    4    7    9    8    7    7 ", "   255\t 1    6   18   23   30   28   25   25 ", 
                               "", "/* Chains */", " nchains: 12", "   id\tsteps\tdepth\torigins", 
                               "   1\t2\t1\t2", "   2\t1\t1\t1", "   3\t3\t1\t3", "   4\t3\t2\t2", 
                               "   5\t1\t1\t1", "   6\t1\t1\t1", "   7\t2\t1\t2", "   8\t3\t2\t2", 
                               "   9\t4\t2\t3", "   10\t2\t2\t1", "   11\t3\t2\t2", "   12\t1\t1\t1", 
                               "", "/* Count when mu at loci i->j are both beneficials (first i, then j) */", 
                               "   1->2: 40", "   1->3: 47", "   1->4: 43", "   1->5: 51", "   1->6: 42", 
                               "   1->7: 50", "   1->8: 44", "   2->1: 40", "   2->3: 45", "   2->4: 44", 
                               "   2->5: 48", "   2->6: 49", "   2->7: 50", "   2->8: 45", "   3->1: 47", 
                               "   3->2: 45", "   3->4: 53", "   3->5: 49", "   3->6: 49", "   3->7: 50", 
                               "   3->8: 48", "   4->1: 43", "   4->2: 44", "   4->3: 53", "   4->5: 47", 
                               "   4->6: 44", "   4->7: 44", "   4->8: 42", "   5->1: 51", "   5->2: 48", 
                               "   5->3: 49", "   5->4: 47", "   5->6: 51", "   5->7: 48", "   5->8: 46", 
                               "   6->1: 42", "   6->2: 49", "   6->3: 49", "   6->4: 44", "   6->5: 51", 
                               "   6->7: 39", "   6->8: 40", "   7->1: 50", "   7->2: 50", "   7->3: 50", 
                               "   7->4: 44", "   7->5: 48", "   7->6: 39", "   7->8: 41", "   8->1: 44", 
                               "   8->2: 45", "   8->3: 48", "   8->4: 42", "   8->5: 46", "   8->6: 40", 
                               "   8->7: 41", "Pairs Mean: 46.035714 ; Stdev: 3.780160 ; Skewness: -0.166924", 
                               "", "/* Adaptive walk statistics */", "G\tE[steps]\tV[steps]\tReachblty\tFitterG\tP[7]\tP[17]\tP[29]\tP[32]\tP[35]\tP[59]\tP[66]\tP[75]\tP[76]\tP[80]\tP[100]\tP[109]\tP[117]\tP[118]\tP[137]\tP[172]\tP[175]\tP[186]\tP[213]\tP[230]\tP[232]\tP[242]\tP[251]", 
                               "0\t2.569\t1.464\t40\t101\t\t-0.000\t0.091\t-0.000\t0.243\t0.000\t-0.000\t0.297\t0.107\t0.046\t0.068\t0.077\t0.000\t0.000\t0.017\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.053\t0.000\t-0.000\t-0.000", 
                               "1\t2.273\t0.926\t6\t51\t\t0.000\t0.364\t0.000\t-0.000\t-0.000\t-0.000\t0.113\t0.524\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t-0.000\t-0.000", 
                               "2\t1.000\t0.000\t1\t8\t\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t1.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000", 
                               "3\t1.909\t0.787\t18\t84\t\t0.157\t0.075\t-0.000\t0.000\t0.158\t0.000\t0.293\t0.305\t-0.000\t0.002\t0.000\t0.000\t0.000\t0.010\t0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000", 
                               "4\t2.422\t0.551\t9\t59\t\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.116\t0.000\t0.264\t0.000\t0.467\t0.000\t-0.000\t0.045\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t0.108\t-0.000\t0.000\t0.000", 
                               "5\t2.685\t1.812\t28\t158\t\t0.314\t0.108\t-0.000\t-0.000\t-0.000\t-0.000\t0.087\t0.189\t0.085\t0.000\t0.150\t0.000\t-0.000\t0.016\t0.000\t-0.000\t-0.000\t0.000\t0.014\t0.038\t0.000\t0.000\t0.000", 
                               "6\t2.729\t0.955\t38\t155\t\t0.159\t0.000\t0.000\t0.020\t0.008\t-0.000\t0.273\t0.056\t0.036\t0.000\t0.074\t-0.000\t0.000\t0.167\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.208\t0.000\t0.000\t0.000", 
                               "8\t3.149\t0.798\t50\t152\t\t0.006\t0.030\t-0.000\t0.052\t0.000\t0.000\t0.245\t0.446\t0.125\t0.015\t0.032\t-0.000\t-0.000\t0.005\t0.028\t-0.000\t-0.000\t0.000\t0.000\t0.015\t0.000\t0.000\t0.000", 
                               "9\t2.075\t0.838\t9\t129\t\t0.000\t0.087\t-0.000\t-0.000\t0.000\t-0.000\t0.027\t0.654\t0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.231\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.000", 
                               "10\t2.057\t0.103\t8\t38\t\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.584\t0.409\t0.008\t0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000", 
                               "11\t1.000\t0.000\t1\t23\t\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t1.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000", 
                               "12\t2.668\t1.880\t20\t137\t\t0.057\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.148\t0.137\t0.453\t0.000\t0.154\t-0.000\t-0.000\t0.015\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.036\t0.000\t0.000\t-0.000", 
                               "13\t2.517\t1.676\t49\t179\t\t0.152\t0.024\t0.233\t-0.000\t-0.000\t0.000\t0.036\t0.268\t0.080\t-0.000\t0.037\t0.000\t0.000\t0.004\t0.135\t0.018\t0.000\t0.000\t0.001\t0.011\t0.000\t-0.000\t0.000", 
                               "14\t2.847\t0.230\t11\t74\t\t0.188\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.360\t0.447\t0.005\t0.000\t-0.000\t0.000\t-0.000\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000", 
                               "15\t1.510\t0.250\t3\t54\t\t0.490\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.510\t0.000\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000", 
                               "16\t1.699\t1.152\t9\t72\t\t-0.000\t0.292\t-0.000\t0.000\t0.000\t0.000\t0.210\t0.000\t0.000\t0.417\t0.000\t0.000\t-0.000\t0.081\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000", 
                               "18\t2.262\t0.193\t7\t37\t\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.680\t0.000\t0.000\t0.058\t0.000\t-0.000\t-0.000\t0.262\t-0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000", 
                               "19\t2.168\t1.377\t9\t69\t\t0.000\t0.484\t0.000\t0.000\t0.000\t-0.000\t0.351\t0.000\t0.000\t0.030\t0.000\t-0.000\t0.000\t0.135\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000", 
                               "20\t3.556\t1.846\t36\t161\t\t-0.000\t0.067\t-0.000\t0.000\t-0.000\t0.000\t0.079\t0.000\t0.070\t0.127\t0.123\t-0.000\t-0.000\t0.361\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.172\t0.000\t-0.000\t-0.000", 
                               "21\t2.133\t2.896\t63\t182\t\t0.073\t0.352\t0.316\t0.000\t-0.000\t0.001\t0.029\t0.027\t0.015\t0.012\t0.027\t0.000\t0.000\t0.104\t-0.000\t-0.000\t-0.000\t0.000\t0.002\t0.041\t0.000\t0.000\t0.000", 
                               "22\t2.000\t0.000\t2\t32\t\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t1.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000", 
                               "23\t3.043\t1.880\t37\t145\t\t0.218\t0.085\t0.039\t-0.000\t0.000\t0.005\t0.074\t0.035\t0.000\t0.005\t0.000\t0.001\t0.000\t0.410\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.129\t-0.000\t-0.000\t-0.000", 
                               "24\t3.400\t1.443\t84\t241\t\t0.001\t0.133\t0.049\t0.006\t0.000\t0.009\t0.273\t0.204\t0.037\t0.207\t0.004\t0.000\t-0.000\t0.066\t0.006\t0.000\t0.000\t0.000\t0.000\t0.004\t0.000\t0.000\t0.000", 
                               "25\t1.801\t1.818\t26\t141\t\t0.000\t0.381\t0.321\t-0.000\t-0.000\t0.060\t0.060\t0.141\t0.000\t0.003\t0.000\t0.000\t0.000\t0.016\t0.017\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.000", 
                               "26\t3.163\t0.160\t15\t49\t\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.634\t0.197\t0.004\t0.030\t0.000\t-0.000\t-0.000\t0.136\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.000", 
                               "27\t2.539\t1.705\t19\t96\t\t0.000\t0.097\t-0.000\t0.000\t0.000\t0.236\t0.229\t0.363\t0.001\t0.014\t0.000\t-0.000\t0.000\t0.061\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000", 
                               "28\t2.768\t4.039\t50\t196\t\t0.018\t0.008\t0.459\t0.000\t-0.000\t0.000\t0.057\t0.044\t0.152\t0.016\t0.064\t-0.000\t-0.000\t0.072\t-0.000\t0.018\t0.000\t-0.000\t-0.000\t0.091\t0.000\t0.000\t0.000", 
                               "30\t3.771\t0.838\t33\t215\t\t0.062\t0.003\t0.054\t-0.000\t-0.000\t0.007\t0.207\t0.167\t0.002\t0.011\t0.000\t0.000\t0.000\t0.374\t0.000\t0.000\t-0.000\t0.000\t-0.000\t0.113\t0.000\t0.000\t-0.000", 
                               "31\t2.160\t1.424\t23\t116\t\t0.202\t0.021\t0.376\t0.000\t-0.000\t0.050\t0.049\t0.287\t0.000\t0.003\t0.000\t-0.000\t-0.000\t0.013\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.000", 
                               "33\t2.374\t1.821\t12\t139\t\t-0.000\t0.076\t-0.000\t0.356\t0.222\t-0.000\t0.061\t0.284\t0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t0.000\t-0.000\t-0.000", 
                               "34\t1.484\t0.250\t5\t63\t\t0.000\t-0.000\t0.000\t0.278\t0.238\t-0.000\t0.484\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t-0.000\t0.000\t-0.000\t-0.000", 
                               "36\t1.513\t1.096\t11\t83\t\t-0.000\t0.000\t0.000\t0.386\t-0.000\t0.000\t0.024\t0.000\t0.056\t0.000\t0.502\t0.000\t-0.000\t0.010\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.023\t0.000\t-0.000\t0.000", 
                               "37\t3.017\t1.707\t52\t194\t\t0.048\t0.035\t0.000\t0.242\t0.059\t-0.000\t0.046\t0.136\t0.035\t0.000\t0.258\t0.079\t0.038\t0.006\t-0.000\t-0.000\t-0.000\t-0.000\t0.003\t0.015\t0.000\t0.000\t0.000", 
                               "38\t2.588\t0.873\t28\t130\t\t0.000\t0.000\t0.000\t0.310\t0.121\t0.000\t0.263\t-0.000\t0.024\t0.001\t0.219\t-0.000\t-0.000\t0.041\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.020\t-0.000\t0.001\t0.000", 
                               "39\t2.016\t1.451\t35\t177\t\t0.274\t0.000\t-0.000\t0.057\t0.296\t-0.000\t0.049\t0.003\t0.005\t0.000\t0.041\t0.264\t-0.000\t0.008\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.004\t-0.000\t0.000\t0.000", 
                               "40\t2.805\t1.932\t63\t201\t\t0.001\t0.004\t-0.000\t0.341\t0.050\t0.002\t0.149\t0.221\t0.057\t0.005\t0.050\t0.014\t-0.000\t0.001\t0.004\t0.017\t-0.000\t0.000\t0.000\t0.003\t0.080\t0.000\t0.000", 
                               "41\t3.028\t1.089\t61\t185\t\t0.000\t0.037\t0.004\t0.068\t0.163\t0.028\t0.029\t0.545\t0.001\t0.000\t0.001\t0.071\t0.001\t0.000\t0.049\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.003\t0.000\t0.001", 
                               "42\t2.753\t0.255\t16\t85\t\t-0.000\t-0.000\t-0.000\t0.076\t0.188\t0.006\t0.380\t0.345\t0.003\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t-0.000", 
                               "43\t1.571\t0.245\t5\t58\t\t-0.000\t0.000\t-0.000\t-0.000\t0.407\t0.021\t0.000\t0.571\t0.000\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000", 
                               "44\t2.167\t1.432\t26\t162\t\t0.010\t0.000\t-0.000\t0.109\t-0.000\t-0.000\t0.033\t0.024\t0.185\t0.000\t0.264\t0.091\t-0.000\t0.005\t-0.000\t0.267\t-0.000\t0.000\t-0.000\t0.013\t0.000\t0.000\t0.000", 
                               "45\t1.561\t1.070\t46\t188\t\t0.002\t0.000\t0.084\t0.017\t-0.000\t0.000\t0.005\t0.004\t0.029\t0.000\t0.042\t0.744\t0.024\t0.004\t0.000\t0.042\t-0.000\t-0.000\t0.000\t0.002\t0.000\t0.000\t0.000", 
                               "46\t3.697\t0.529\t47\t198\t\t0.065\t0.000\t0.000\t0.110\t0.092\t0.002\t0.316\t0.269\t0.024\t0.000\t0.075\t0.007\t-0.000\t0.010\t0.000\t0.022\t0.000\t-0.000\t-0.000\t0.006\t-0.000\t0.000\t-0.000", 
                               "47\t2.081\t0.495\t38\t181\t\t0.130\t0.000\t0.000\t0.000\t0.107\t0.006\t0.000\t0.286\t0.000\t0.000\t0.000\t0.263\t-0.000\t0.000\t0.000\t0.000\t0.208\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t-0.000", 
                               "48\t2.294\t1.472\t18\t120\t\t0.000\t0.067\t0.000\t0.302\t0.010\t-0.000\t0.166\t0.000\t0.000\t0.361\t0.000\t0.000\t0.000\t0.073\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.021\t-0.000", 
                               "49\t2.449\t2.359\t75\t225\t\t0.000\t0.427\t0.005\t0.174\t0.056\t0.028\t0.068\t0.085\t0.000\t0.113\t0.000\t0.005\t0.008\t0.023\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.007\t0.001", 
                               "50\t2.882\t0.416\t15\t73\t\t0.000\t-0.000\t0.000\t0.052\t0.045\t-0.000\t0.524\t0.000\t0.000\t0.046\t0.000\t-0.000\t-0.000\t0.241\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.091\t-0.000", 
                               "51\t2.559\t2.407\t51\t216\t\t0.000\t0.102\t0.000\t0.011\t0.229\t0.211\t0.231\t0.032\t0.000\t0.022\t0.000\t0.005\t-0.000\t0.114\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.041\t0.002", 
                               "52\t3.872\t2.906\t54\t245\t\t-0.000\t0.017\t-0.000\t0.147\t0.004\t0.000\t0.062\t0.000\t0.019\t0.103\t0.150\t0.002\t0.025\t0.252\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.212\t-0.000\t0.007\t0.000", 
                               "53\t1.266\t0.436\t27\t227\t\t0.000\t0.000\t0.102\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.038\t0.855\t0.004\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000", 
                               "54\t3.125\t2.299\t21\t126\t\t0.000\t-0.000\t-0.000\t0.012\t0.010\t-0.000\t0.117\t-0.000\t0.000\t0.010\t-0.000\t-0.000\t-0.000\t0.661\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.171\t-0.000\t0.020\t-0.000", 
                               "55\t4.081\t2.123\t54\t236\t\t0.096\t0.037\t0.017\t0.007\t0.008\t0.002\t0.098\t0.015\t0.000\t0.008\t0.000\t0.002\t0.000\t0.547\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.151\t0.000\t0.011\t-0.000", 
                               "56\t3.300\t1.625\t92\t229\t\t0.000\t0.070\t0.015\t0.251\t0.008\t0.076\t0.140\t0.025\t0.000\t0.300\t0.000\t0.010\t0.004\t0.062\t0.001\t0.000\t-0.000\t0.007\t-0.000\t0.002\t0.006\t0.019\t0.003", 
                               "57\t2.275\t2.195\t59\t169\t\t0.000\t0.094\t0.099\t0.000\t-0.000\t0.493\t0.022\t0.163\t0.001\t0.001\t0.000\t0.066\t0.026\t0.008\t0.004\t0.000\t0.000\t0.000\t0.000\t0.000\t0.001\t0.000\t0.021", 
                               "58\t2.963\t2.098\t45\t178\t\t0.000\t0.000\t-0.000\t0.023\t0.040\t0.187\t0.311\t0.112\t0.002\t0.021\t0.000\t0.000\t0.000\t0.133\t0.000\t0.000\t0.000\t0.137\t0.000\t0.000\t0.000\t0.031\t0.002", 
                               "60\t2.965\t0.493\t53\t247\t\t0.002\t0.000\t0.110\t0.023\t0.000\t0.000\t0.007\t0.005\t0.120\t0.000\t0.140\t0.182\t0.063\t0.289\t0.000\t0.055\t0.000\t0.000\t0.000\t0.003\t0.000\t-0.000\t0.000", 
                               "61\t1.524\t0.581\t36\t164\t\t0.000\t0.000\t0.585\t0.000\t-0.000\t0.001\t0.000\t0.001\t0.000\t0.000\t-0.000\t0.220\t0.171\t0.022\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000", 
                               "62\t2.915\t2.097\t23\t210\t\t0.000\t-0.000\t-0.000\t0.005\t0.004\t-0.000\t0.050\t-0.000\t0.000\t0.004\t-0.000\t-0.000\t-0.000\t0.854\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.073\t-0.000\t0.009\t-0.000", 
                               "63\t2.320\t1.418\t43\t219\t\t0.058\t0.006\t0.150\t-0.000\t-0.000\t0.367\t0.014\t0.088\t0.000\t0.001\t-0.000\t0.176\t0.013\t0.126\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.002", 
                               "64\t2.084\t0.979\t30\t82\t\t-0.000\t0.000\t-0.000\t0.028\t0.000\t0.000\t0.268\t0.292\t0.086\t0.190\t0.108\t0.000\t-0.000\t0.007\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.019\t0.001\t0.000\t0.000", 
                               "65\t2.000\t0.000\t5\t21\t\t0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.177\t0.823\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000", 
                               "67\t1.000\t0.000\t3\t12\t\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.483\t0.517\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000", 
                               "68\t1.422\t0.551\t8\t29\t\t-0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.116\t0.000\t0.264\t0.000\t0.467\t0.000\t0.000\t0.045\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.108\t0.000\t0.000\t0.000", 
                               "69\t2.897\t0.865\t24\t144\t\t0.071\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.188\t0.327\t0.069\t0.000\t0.122\t0.005\t0.000\t0.026\t0.000\t0.000\t0.000\t-0.000\t0.129\t0.062\t-0.000\t-0.000\t0.000", 
                               "70\t1.570\t0.245\t5\t15\t\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.430\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.000\t0.168\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.403\t0.000\t-0.000\t-0.000", 
                               "71\t1.924\t0.495\t13\t57\t\t0.288\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.317\t0.183\t-0.000\t-0.000\t-0.000\t0.018\t0.000\t0.057\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.137\t0.000\t0.000\t0.000", 
                               "72\t1.765\t0.180\t3\t19\t\t0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.765\t0.235\t0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.000", 
                               "73\t1.000\t0.000\t1\t6\t\t0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t1.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000", 
                               "74\t1.234\t0.383\t5\t27\t\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.428\t0.541\t0.031\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000", 
                               "77\t2.031\t1.356\t43\t240\t\t0.032\t0.000\t0.135\t-0.000\t-0.000\t0.000\t0.033\t0.301\t0.205\t0.000\t0.014\t0.234\t0.003\t0.005\t0.000\t-0.000\t0.000\t-0.000\t0.014\t0.022\t-0.000\t0.000\t0.000", 
                               "78\t2.659\t1.128\t38\t138\t\t0.037\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.219\t0.191\t0.176\t0.004\t-0.000\t0.013\t0.000\t0.118\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.243\t0.000\t-0.000\t-0.000", 
                               "79\t2.340\t1.138\t22\t118\t\t0.159\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.079\t0.436\t0.000\t0.000\t-0.000\t0.212\t-0.000\t0.012\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.102\t0.000\t0.000\t-0.000", 
                               "81\t2.449\t2.081\t65\t202\t\t0.001\t0.222\t-0.000\t0.000\t0.000\t0.000\t0.148\t0.274\t0.000\t0.266\t0.000\t0.001\t0.004\t0.042\t0.000\t0.000\t-0.000\t-0.000\t0.040\t0.001\t0.000\t0.000\t0.000", 
                               "82\t1.322\t0.218\t4\t24\t\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.472\t0.000\t0.000\t0.206\t0.000\t0.000\t0.000\t0.322\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000", 
                               "83\t2.855\t0.842\t24\t88\t\t0.007\t0.063\t-0.000\t0.000\t0.000\t0.000\t0.401\t0.256\t0.000\t0.054\t0.000\t0.000\t0.000\t0.217\t0.000\t0.000\t0.000\t0.000\t0.000\t0.003\t0.000\t0.000\t0.000", 
                               "84\t1.805\t0.537\t10\t146\t\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.038\t0.000\t0.087\t0.334\t0.154\t0.000\t0.000\t0.351\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.036\t-0.000\t-0.000\t0.000", 
                               "85\t2.147\t1.382\t39\t235\t\t0.018\t0.000\t0.144\t-0.000\t0.000\t0.000\t0.037\t0.045\t0.018\t0.038\t0.032\t0.005\t0.208\t0.214\t0.000\t0.000\t-0.000\t-0.000\t0.224\t0.016\t-0.000\t-0.000\t0.000", 
                               "86\t1.000\t0.000\t1\t10\t\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t1.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000", 
                               "87\t2.148\t0.195\t14\t67\t\t0.046\t0.000\t0.000\t-0.000\t0.000\t-0.000\t0.051\t0.029\t0.000\t-0.000\t0.000\t0.003\t0.000\t0.849\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.022\t0.000\t-0.000\t-0.000", 
                               "88\t2.264\t1.335\t17\t90\t\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.111\t0.351\t0.092\t0.409\t0.000\t-0.000\t0.000\t0.037\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000", 
                               "89\t2.927\t1.633\t66\t207\t\t0.000\t0.050\t0.178\t0.000\t0.000\t0.028\t0.078\t0.462\t0.018\t0.091\t0.000\t0.032\t0.013\t0.026\t0.002\t-0.000\t-0.000\t0.000\t0.009\t0.000\t0.001\t0.000\t0.010", 
                               "90\t2.552\t0.722\t16\t64\t\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.477\t0.257\t0.014\t0.094\t0.000\t0.000\t0.000\t0.159\t-0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000", 
                               "91\t2.438\t2.215\t34\t104\t\t0.001\t0.017\t0.000\t0.000\t0.000\t0.018\t0.231\t0.602\t0.004\t0.039\t0.000\t0.000\t0.000\t0.088\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.000", 
                               "92\t2.614\t1.479\t83\t183\t\t0.000\t0.000\t0.142\t0.000\t0.000\t0.000\t0.053\t0.081\t0.254\t0.120\t0.037\t0.032\t0.010\t0.253\t0.000\t0.000\t0.000\t-0.000\t0.001\t0.015\t0.000\t0.000\t0.000", 
                               "93\t1.068\t0.107\t24\t125\t\t-0.000\t0.000\t0.946\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.029\t0.022\t0.003\t0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000", 
                               "94\t2.484\t0.742\t18\t92\t\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.149\t0.080\t0.004\t0.029\t0.000\t0.000\t0.000\t0.738\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000", 
                               "95\t3.144\t1.058\t60\t250\t\t0.055\t0.005\t0.166\t-0.000\t-0.000\t0.011\t0.082\t0.205\t0.001\t0.011\t-0.000\t0.107\t0.003\t0.325\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.024\t-0.000\t-0.000\t0.006", 
                               "96\t1.599\t0.920\t11\t60\t\t-0.000\t-0.000\t0.000\t0.299\t-0.000\t-0.000\t0.226\t0.093\t0.000\t0.053\t0.328\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000", 
                               "97\t3.000\t0.000\t6\t45\t\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.177\t0.823\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000", 
                               "98\t1.000\t0.000\t1\t36\t\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t1.000\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000", 
                               "99\t2.458\t1.077\t14\t93\t\t-0.000\t0.000\t-0.000\t-0.000\t0.164\t-0.000\t0.317\t0.397\t0.000\t0.000\t0.000\t0.121\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000", 
                               "101\t2.046\t1.692\t27\t151\t\t0.002\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.040\t0.170\t0.002\t-0.000\t0.205\t0.385\t0.189\t0.001\t0.000\t-0.000\t0.000\t-0.000\t0.004\t0.002\t-0.000\t-0.000\t-0.000", 
                               "102\t1.924\t1.006\t34\t167\t\t0.000\t0.000\t0.000\t0.029\t0.011\t-0.000\t0.240\t0.001\t0.002\t0.000\t0.173\t0.145\t0.000\t0.182\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.216\t0.000\t0.000\t0.000", 
                               "103\t2.010\t0.010\t4\t55\t\t0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.010\t-0.000\t-0.000\t-0.000\t0.990\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.000", 
                               "104\t2.083\t0.885\t17\t102\t\t0.000\t0.000\t0.000\t0.074\t0.000\t0.000\t0.056\t0.277\t0.110\t0.013\t0.116\t0.033\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.320\t0.000\t0.000", 
                               "105\t2.218\t1.165\t19\t107\t\t-0.000\t-0.000\t0.000\t0.002\t0.000\t0.000\t0.041\t0.679\t0.003\t0.000\t0.003\t0.261\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.009\t-0.000\t0.000", 
                               "106\t2.788\t1.003\t61\t165\t\t0.000\t0.000\t-0.000\t0.021\t0.027\t0.004\t0.325\t0.357\t0.022\t0.007\t0.016\t0.004\t-0.000\t0.052\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.061\t0.090\t0.012\t0.002", 
                               "107\t1.000\t0.000\t1\t46\t\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t1.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000", 
                               "108\t1.000\t0.000\t3\t89\t\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.327\t-0.000\t0.344\t0.329\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000", 
                               "110\t2.328\t0.647\t80\t239\t\t0.005\t0.000\t-0.000\t0.002\t0.001\t0.000\t0.051\t0.042\t0.086\t0.001\t0.071\t0.269\t0.000\t0.218\t0.000\t0.000\t-0.000\t0.000\t-0.000\t0.249\t0.004\t0.000\t0.000", 
                               "111\t1.010\t0.010\t3\t47\t\t-0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.010\t-0.000\t-0.000\t-0.000\t0.990\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000", 
                               "112\t1.000\t0.000\t1\t52\t\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t1.000\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000", 
                               "113\t2.870\t1.983\t60\t173\t\t0.000\t0.003\t0.000\t0.000\t0.007\t0.023\t0.100\t0.287\t0.000\t0.231\t0.000\t0.036\t0.235\t0.041\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.000\t0.001\t0.024\t0.013", 
                               "114\t1.482\t0.396\t8\t53\t\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.283\t0.000\t0.000\t0.053\t0.000\t0.000\t0.000\t0.358\t0.000\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.306\t0.000", 
                               "115\t3.094\t1.065\t47\t113\t\t0.002\t0.017\t-0.000\t-0.000\t0.039\t0.019\t0.309\t0.187\t0.000\t0.038\t0.000\t0.029\t0.000\t0.215\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.001\t0.000\t0.133\t0.011", 
                               "116\t1.449\t0.501\t27\t153\t\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.001\t0.000\t0.015\t0.225\t0.244\t0.017\t0.218\t0.278\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.001\t-0.000\t-0.000\t0.000", 
                               "119\t2.583\t1.691\t55\t222\t\t0.008\t0.002\t-0.000\t0.000\t0.005\t0.004\t0.056\t0.041\t0.000\t0.005\t-0.000\t0.253\t0.164\t0.394\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t0.018\t-0.000\t0.018\t0.031", 
                               "120\t3.006\t1.036\t61\t224\t\t0.000\t0.000\t-0.000\t0.011\t0.000\t0.019\t0.063\t0.166\t0.048\t0.273\t0.034\t0.053\t0.014\t0.122\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.150\t0.036\t0.011", 
                               "121\t2.808\t1.029\t53\t133\t\t0.000\t0.001\t-0.000\t0.001\t-0.000\t0.132\t0.026\t0.461\t0.002\t0.001\t0.002\t0.210\t0.074\t0.012\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.004\t-0.000\t0.074", 
                               "122\t2.699\t0.799\t40\t117\t\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.026\t0.248\t0.113\t0.004\t0.048\t0.000\t0.000\t-0.000\t0.444\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.102\t0.015", 
                               "123\t1.583\t0.744\t37\t110\t\t0.000\t0.001\t-0.000\t-0.000\t-0.000\t0.349\t0.020\t0.423\t0.000\t0.003\t-0.000\t0.000\t0.000\t0.008\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.195", 
                               "124\t2.033\t0.066\t34\t132\t\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.135\t0.000\t0.142\t0.202\t0.052\t0.469\t0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000", 
                               "125\t1.262\t0.468\t36\t123\t\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.002\t0.000\t0.003\t0.000\t0.000\t-0.000\t0.530\t0.411\t0.053\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.001", 
                               "126\t1.000\t0.000\t1\t77\t\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t1.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t-0.000", 
                               "127\t2.026\t0.043\t38\t112\t\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.012\t0.001\t0.020\t0.000\t0.000\t-0.000\t0.546\t-0.000\t0.413\t0.000\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.007", 
                               "128\t2.937\t0.857\t22\t80\t\t0.000\t-0.000\t-0.000\t0.456\t0.000\t-0.000\t0.154\t0.003\t0.000\t0.004\t-0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.382\t0.001\t-0.000\t-0.000", 
                               "129\t3.042\t1.684\t27\t128\t\t0.000\t0.083\t-0.000\t0.209\t-0.000\t0.000\t0.135\t0.276\t0.000\t0.001\t0.000\t0.000\t0.000\t0.000\t0.220\t-0.000\t-0.000\t-0.000\t0.000\t0.075\t0.000\t-0.000\t-0.000", 
                               "130\t2.715\t0.204\t5\t11\t\t0.000\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t0.285\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.715\t-0.000\t-0.000\t-0.000", 
                               "131\t3.609\t1.356\t62\t168\t\t0.056\t0.032\t-0.000\t0.043\t0.046\t0.000\t0.246\t0.266\t0.000\t0.001\t0.000\t0.000\t0.000\t0.022\t0.058\t-0.000\t0.001\t-0.000\t0.000\t0.228\t0.000\t0.000\t-0.000", 
                               "132\t3.765\t1.726\t59\t200\t\t0.001\t0.000\t-0.000\t0.081\t-0.000\t0.000\t0.066\t0.019\t0.068\t0.009\t0.118\t0.000\t0.000\t0.058\t-0.000\t0.089\t0.000\t0.000\t0.015\t0.473\t0.003\t0.000\t-0.000", 
                               "133\t3.521\t2.193\t62\t191\t\t0.097\t0.030\t0.000\t0.046\t-0.000\t0.000\t0.095\t0.177\t0.011\t0.000\t0.017\t0.000\t0.000\t0.017\t0.173\t0.024\t-0.000\t-0.000\t0.170\t0.143\t0.000\t-0.000\t0.000", 
                               "134\t2.000\t0.000\t2\t7\t\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t1.000\t-0.000\t-0.000\t-0.000", 
                               "135\t3.063\t2.165\t20\t127\t\t0.281\t-0.000\t0.000\t-0.000\t-0.000\t0.000\t0.054\t0.051\t-0.000\t0.000\t0.000\t0.001\t0.000\t0.070\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.544\t0.000\t0.000\t-0.000", 
                               "136\t2.848\t2.191\t78\t176\t\t0.003\t0.004\t-0.000\t0.114\t0.000\t0.000\t0.070\t0.168\t0.057\t0.004\t0.006\t0.000\t0.000\t0.002\t0.246\t0.117\t0.000\t0.000\t-0.000\t0.107\t0.103\t0.000\t-0.000", 
                               "138\t3.779\t1.101\t74\t211\t\t0.006\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.274\t0.273\t0.006\t0.003\t0.000\t0.000\t-0.000\t0.025\t0.043\t0.000\t0.000\t0.012\t0.000\t0.348\t0.008\t0.000\t-0.000", 
                               "139\t1.946\t0.819\t7\t131\t\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.062\t0.628\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.310\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000", 
                               "140\t1.743\t2.105\t29\t140\t\t0.012\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.028\t0.029\t0.053\t-0.000\t0.018\t-0.000\t0.000\t0.008\t-0.000\t0.762\t0.000\t-0.000\t-0.000\t0.090\t0.000\t0.000\t0.000", 
                               "141\t1.347\t0.902\t31\t149\t\t0.002\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.006\t0.006\t0.011\t0.000\t0.004\t0.000\t0.000\t0.002\t0.801\t0.151\t-0.000\t-0.000\t-0.000\t0.018\t0.000\t-0.000\t0.000", 
                               "142\t3.550\t0.615\t22\t136\t\t0.046\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.088\t0.109\t0.001\t0.000\t-0.000\t-0.000\t-0.000\t0.049\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.707\t0.000\t0.000\t-0.000", 
                               "143\t3.051\t1.998\t46\t204\t\t0.137\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.046\t0.265\t0.001\t0.000\t0.000\t0.000\t0.000\t0.016\t0.117\t0.015\t0.149\t-0.000\t0.000\t0.254\t0.000\t-0.000\t-0.000", 
                               "144\t3.150\t1.647\t32\t97\t\t0.000\t0.066\t-0.000\t0.079\t0.000\t0.000\t0.155\t0.001\t0.000\t0.453\t0.000\t-0.000\t-0.000\t0.057\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t0.190\t0.000\t-0.000\t-0.000", 
                               "145\t3.413\t3.304\t43\t234\t\t-0.000\t0.301\t0.000\t0.055\t0.000\t-0.000\t0.142\t0.126\t0.000\t0.152\t0.000\t-0.000\t0.000\t0.034\t0.039\t-0.000\t-0.000\t-0.000\t0.048\t0.102\t0.000\t-0.000\t0.000", 
                               "146\t3.657\t0.225\t13\t68\t\t0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t0.326\t-0.000\t0.000\t0.018\t0.000\t-0.000\t-0.000\t0.157\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.500\t-0.000\t-0.000\t0.000", 
                               "147\t4.205\t0.866\t21\t143\t\t0.000\t0.117\t-0.000\t0.000\t0.000\t0.000\t0.293\t0.138\t0.000\t0.012\t0.000\t-0.000\t-0.000\t0.141\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.299\t-0.000\t0.000\t0.000", 
                               "148\t4.685\t0.919\t34\t99\t\t-0.000\t0.001\t-0.000\t0.001\t-0.000\t-0.000\t0.002\t0.000\t0.000\t0.006\t0.000\t0.000\t-0.000\t0.281\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.709\t0.000\t0.000\t-0.000", 
                               "149\t3.806\t4.624\t33\t212\t\t-0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.001\t0.000\t0.000\t0.002\t0.000\t-0.000\t-0.000\t0.183\t-0.000\t-0.000\t0.000\t-0.000\t0.351\t0.462\t0.000\t0.000\t-0.000", 
                               "150\t3.000\t0.000\t6\t40\t\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.284\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.716\t-0.000\t-0.000\t-0.000", 
                               "151\t4.000\t0.000\t7\t65\t\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t0.284\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t0.716\t-0.000\t0.000\t0.000", 
                               "152\t4.718\t2.031\t68\t174\t\t0.000\t0.035\t-0.000\t0.042\t-0.000\t0.000\t0.193\t0.035\t0.003\t0.248\t0.000\t-0.000\t-0.000\t0.110\t0.000\t0.021\t-0.000\t0.036\t-0.000\t0.276\t0.001\t0.001\t-0.000", 
                               "153\t2.050\t2.513\t80\t242\t\t0.000\t0.131\t0.110\t0.001\t-0.000\t0.021\t0.043\t0.077\t0.000\t0.029\t0.000\t-0.000\t0.000\t0.007\t0.551\t0.000\t0.000\t0.001\t0.024\t0.004\t0.000\t0.000\t0.000", 
                               "154\t4.228\t1.480\t43\t142\t\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.311\t0.096\t0.003\t0.023\t0.000\t-0.000\t-0.000\t0.152\t-0.000\t0.000\t0.000\t0.100\t0.000\t0.309\t0.002\t0.004\t0.000", 
                               "155\t3.942\t2.360\t59\t186\t\t0.000\t0.051\t-0.000\t0.000\t0.005\t0.102\t0.197\t0.296\t0.001\t0.011\t0.000\t-0.000\t-0.000\t0.075\t0.068\t-0.000\t0.004\t0.041\t0.000\t0.118\t0.000\t0.001\t0.030", 
                               "156\t4.739\t2.151\t51\t163\t\t0.003\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.007\t0.007\t0.012\t0.002\t0.004\t0.000\t0.000\t0.218\t-0.000\t0.178\t-0.000\t0.000\t0.000\t0.567\t0.000\t-0.000\t0.000", 
                               "157\t2.014\t2.964\t50\t199\t\t0.001\t0.000\t0.573\t0.000\t-0.000\t0.000\t0.003\t0.003\t0.005\t0.000\t0.002\t-0.000\t0.000\t0.029\t0.238\t0.068\t0.000\t0.000\t-0.000\t0.079\t0.000\t-0.000\t-0.000", 
                               "158\t4.000\t0.000\t7\t106\t\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t0.284\t-0.000\t0.000\t-0.000\t-0.000\t0.000\t0.716\t-0.000\t-0.000\t-0.000", 
                               "159\t4.447\t1.147\t55\t214\t\t0.059\t0.006\t0.109\t-0.000\t-0.000\t0.015\t0.016\t0.089\t0.000\t0.001\t0.000\t0.001\t-0.000\t0.199\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.495\t0.000\t0.000\t0.010", 
                               "160\t1.000\t0.000\t1\t34\t\t-0.000\t0.000\t-0.000\t1.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000", 
                               "161\t2.000\t0.000\t2\t108\t\t-0.000\t-0.000\t0.000\t1.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000", 
                               "162\t2.920\t0.808\t11\t71\t\t-0.000\t-0.000\t-0.000\t0.428\t0.019\t-0.000\t0.186\t-0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.367\t-0.000\t-0.000\t-0.000", 
                               "163\t2.957\t1.736\t26\t148\t\t0.000\t-0.000\t-0.000\t0.279\t0.288\t0.001\t0.162\t0.160\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.001\t-0.000\t0.021\t0.000\t-0.000\t0.088\t-0.000\t0.000\t0.000", 
                               "164\t2.828\t3.251\t35\t218\t\t-0.000\t-0.000\t-0.000\t0.278\t0.001\t-0.000\t0.010\t-0.000\t0.010\t0.000\t0.185\t-0.000\t-0.000\t0.059\t-0.000\t0.176\t0.000\t-0.000\t0.000\t0.280\t-0.000\t0.000\t0.000", 
                               "165\t3.301\t0.750\t35\t232\t\t0.001\t0.000\t-0.000\t0.692\t-0.000\t0.000\t0.030\t0.048\t0.000\t0.000\t0.055\t0.028\t0.004\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.060\t0.083\t-0.000\t0.000\t0.000", 
                               "166\t3.230\t2.220\t32\t156\t\t0.000\t0.000\t-0.000\t0.125\t0.017\t-0.000\t0.069\t-0.000\t0.003\t0.000\t0.024\t0.000\t0.000\t0.066\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.696\t-0.000\t0.000\t-0.000", 
                               "167\t3.236\t3.044\t57\t231\t\t0.065\t-0.000\t-0.000\t0.059\t0.049\t0.000\t0.088\t0.081\t0.000\t0.000\t0.003\t0.065\t0.000\t0.024\t0.000\t-0.000\t0.246\t-0.000\t0.000\t0.318\t-0.000\t0.000\t-0.000", 
                               "168\t1.372\t0.316\t76\t209\t\t0.000\t0.000\t-0.000\t0.343\t0.000\t0.000\t0.000\t0.001\t0.000\t0.001\t0.000\t0.000\t0.000\t0.000\t0.001\t0.305\t-0.000\t0.002\t-0.000\t0.001\t0.345\t0.001\t0.000", 
                               "169\t2.375\t1.358\t33\t228\t\t-0.000\t0.000\t0.000\t0.285\t0.064\t0.003\t0.003\t0.142\t0.000\t0.000\t0.000\t0.018\t-0.000\t-0.000\t0.329\t-0.000\t0.057\t0.000\t-0.000\t0.000\t0.098\t0.000\t0.000", 
                               "170\t3.093\t1.685\t38\t252\t\t-0.000\t0.000\t-0.000\t0.116\t0.092\t0.004\t0.141\t0.169\t0.002\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.002\t0.000\t0.041\t0.177\t-0.000\t0.181\t0.075\t0.000\t-0.000", 
                               "171\t2.183\t0.691\t13\t135\t\t-0.000\t0.000\t-0.000\t-0.000\t0.288\t0.015\t0.002\t0.427\t0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t0.012\t-0.000\t0.256\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000", 
                               "173\t1.310\t0.530\t33\t244\t\t0.001\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.001\t0.001\t0.002\t-0.000\t0.001\t0.000\t0.000\t0.000\t0.185\t0.447\t0.358\t0.000\t0.000\t0.004\t0.000\t-0.000\t-0.000", 
                               "174\t2.232\t2.395\t47\t206\t\t0.008\t-0.000\t0.000\t0.013\t0.002\t-0.000\t0.023\t0.019\t0.000\t0.000\t0.002\t0.000\t0.000\t0.015\t-0.000\t0.240\t0.209\t0.000\t0.000\t0.468\t0.000\t0.000\t-0.000", 
                               "176\t3.503\t2.905\t44\t121\t\t-0.000\t0.012\t-0.000\t0.342\t0.000\t-0.000\t0.028\t0.000\t0.000\t0.225\t-0.000\t-0.000\t-0.000\t0.080\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.208\t0.000\t0.105\t-0.000", 
                               "177\t3.710\t1.934\t46\t246\t\t-0.000\t0.006\t0.000\t0.690\t0.000\t0.000\t0.013\t0.000\t0.000\t0.106\t0.000\t0.000\t0.000\t0.038\t-0.000\t0.000\t-0.000\t0.000\t-0.000\t0.098\t0.000\t0.050\t0.000", 
                               "178\t3.457\t2.996\t47\t237\t\t0.000\t0.001\t0.000\t0.113\t0.010\t-0.000\t0.160\t0.000\t0.000\t0.036\t0.000\t-0.000\t-0.000\t0.113\t-0.000\t-0.000\t-0.000\t0.116\t0.000\t0.266\t0.000\t0.185\t-0.000", 
                               "179\t4.130\t2.345\t43\t190\t\t0.000\t0.049\t-0.000\t0.099\t0.114\t0.074\t0.181\t0.131\t-0.000\t0.005\t0.000\t0.000\t-0.000\t0.059\t0.001\t-0.000\t0.017\t0.046\t0.000\t0.157\t0.000\t0.000\t0.066", 
                               "180\t5.000\t0.000\t8\t81\t\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.284\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.716\t-0.000\t-0.000\t-0.000", 
                               "181\t6.000\t0.000\t9\t193\t\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.284\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.716\t-0.000\t-0.000\t-0.000", 
                               "182\t4.000\t0.000\t7\t61\t\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.284\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.716\t-0.000\t-0.000\t-0.000", 
                               "183\t4.832\t0.407\t43\t253\t\t0.001\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.015\t0.016\t0.000\t0.000\t0.000\t0.030\t0.000\t0.240\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.626\t-0.000\t0.000\t0.073", 
                               "184\t2.695\t3.126\t77\t175\t\t0.000\t0.004\t0.000\t0.109\t0.000\t0.000\t0.009\t0.000\t0.000\t0.145\t0.000\t-0.000\t0.000\t0.026\t-0.000\t0.000\t-0.000\t0.309\t-0.000\t0.067\t0.245\t0.086\t-0.000", 
                               "185\t2.701\t1.528\t102\t251\t\t0.000\t0.028\t0.030\t0.005\t0.032\t0.364\t0.007\t0.097\t0.000\t0.007\t0.000\t0.020\t0.008\t0.004\t0.003\t0.000\t0.029\t0.150\t-0.000\t0.003\t0.011\t0.004\t0.200", 
                               "187\t1.373\t0.793\t16\t159\t\t-0.000\t0.000\t-0.000\t0.000\t0.049\t0.329\t0.000\t0.073\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.002\t-0.000\t0.044\t0.208\t-0.000\t0.000\t0.000\t0.000\t0.295", 
                               "188\t3.795\t6.227\t63\t249\t\t0.000\t0.000\t-0.000\t0.001\t0.000\t-0.000\t0.001\t0.001\t0.001\t0.002\t0.000\t-0.000\t-0.000\t0.152\t-0.000\t0.449\t0.000\t0.003\t0.000\t0.385\t0.003\t0.001\t-0.000", 
                               "189\t2.524\t0.581\t37\t208\t\t0.000\t0.000\t0.585\t0.000\t-0.000\t0.001\t0.000\t0.001\t0.000\t0.000\t-0.000\t0.220\t0.171\t0.022\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000", 
                               "190\t3.855\t3.269\t10\t184\t\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t0.203\t0.000\t0.000\t-0.000\t0.286\t-0.000\t0.511\t-0.000\t0.000\t-0.000", 
                               "191\t1.782\t0.784\t43\t217\t\t0.000\t0.000\t-0.000\t0.000\t0.008\t0.056\t0.000\t0.014\t0.000\t0.000\t0.000\t0.035\t-0.000\t0.026\t0.000\t0.000\t0.418\t0.035\t-0.000\t0.000\t0.000\t-0.000\t0.408", 
                               "192\t3.017\t1.023\t19\t79\t\t0.000\t-0.000\t0.000\t-0.000\t0.000\t-0.000\t0.182\t0.283\t0.033\t0.297\t0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.105\t0.100\t-0.000\t-0.000", 
                               "193\t3.000\t0.000\t6\t44\t\t0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.337\t0.663\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000", 
                               "194\t2.342\t1.120\t9\t43\t\t0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.447\t0.109\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.444\t0.000\t0.000\t-0.000", 
                               "195\t2.000\t0.000\t6\t18\t\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.483\t0.517\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000", 
                               "196\t2.637\t1.207\t34\t105\t\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.084\t0.089\t0.078\t0.046\t0.184\t0.000\t0.000\t0.013\t-0.000\t0.000\t0.000\t0.000\t0.091\t0.400\t0.015\t0.000\t0.000", 
                               "197\t2.294\t2.204\t19\t76\t\t0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.145\t0.284\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.568\t0.002\t-0.000\t-0.000\t0.000", 
                               "198\t1.000\t0.000\t1\t4\t\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t1.000\t-0.000\t-0.000\t-0.000", 
                               "199\t2.565\t0.327\t15\t75\t\t0.055\t0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.248\t0.236\t-0.000\t-0.000\t-0.000\t0.004\t0.000\t0.011\t0.000\t0.000\t0.000\t0.000\t0.000\t0.447\t0.000\t0.000\t0.000", 
                               "200\t2.033\t0.862\t5\t42\t\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.448\t0.137\t0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.415\t0.000\t0.000", 
                               "201\t2.658\t1.547\t31\t233\t\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.099\t0.555\t0.024\t0.008\t0.000\t0.010\t-0.000\t0.000\t0.172\t0.000\t0.000\t0.000\t0.008\t0.000\t0.125\t0.000\t0.000", 
                               "202\t2.746\t0.618\t19\t48\t\t0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t0.201\t0.393\t0.021\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.348\t0.037\t-0.000\t-0.000", 
                               "203\t1.748\t0.937\t4\t35\t\t-0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.181\t0.819\t0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000", 
                               "204\t2.702\t1.717\t69\t254\t\t0.002\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.020\t0.118\t0.272\t0.010\t0.037\t0.000\t0.000\t0.009\t-0.000\t0.103\t0.000\t0.000\t0.018\t0.319\t0.093\t-0.000\t0.000", 
                               "205\t3.356\t1.629\t46\t226\t\t0.003\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.101\t0.261\t0.002\t-0.000\t0.001\t0.000\t0.000\t0.001\t0.169\t0.032\t-0.000\t-0.000\t0.227\t0.202\t-0.000\t-0.000\t0.000", 
                               "206\t2.000\t0.000\t3\t22\t\t0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t1.000\t0.000\t-0.000\t0.000", 
                               "207\t2.967\t0.503\t19\t86\t\t0.007\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.108\t0.375\t0.000\t0.000\t0.000\t0.000\t0.000\t0.001\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.508\t0.000\t-0.000\t0.000", 
                               "208\t1.000\t0.000\t1\t28\t\t0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t1.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t-0.000", 
                               "209\t2.730\t1.688\t11\t122\t\t-0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.203\t0.289\t0.000\t0.254\t0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.254\t0.000\t-0.000\t-0.000\t0.000", 
                               "210\t2.805\t1.540\t22\t100\t\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.240\t0.092\t0.000\t0.185\t0.000\t0.000\t0.000\t0.130\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.189\t0.000\t0.164\t-0.000", 
                               "211\t3.000\t0.000\t7\t33\t\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.483\t0.517\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000", 
                               "212\t2.958\t2.697\t48\t160\t\t0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.017\t0.015\t0.019\t0.233\t0.041\t0.000\t0.000\t0.165\t-0.000\t-0.000\t0.000\t-0.000\t0.214\t0.293\t0.003\t-0.000\t-0.000", 
                               "214\t2.111\t0.210\t7\t41\t\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.457\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.543\t-0.000\t-0.000\t0.000", 
                               "215\t3.363\t1.651\t56\t230\t\t0.016\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.126\t0.128\t0.000\t0.000\t0.000\t0.012\t-0.000\t0.248\t-0.000\t-0.000\t-0.000\t-0.000\t0.156\t0.282\t0.000\t-0.000\t0.031", 
                               "216\t3.174\t1.743\t82\t213\t\t0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.078\t0.211\t0.047\t0.339\t0.000\t0.000\t0.000\t0.030\t-0.000\t0.001\t-0.000\t0.000\t0.010\t0.049\t0.206\t0.030\t0.000", 
                               "217\t3.730\t1.688\t12\t166\t\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.203\t0.289\t0.000\t0.254\t0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.254\t0.000\t-0.000\t-0.000\t0.000", 
                               "218\t3.724\t0.818\t41\t114\t\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.293\t0.265\t0.014\t0.064\t0.000\t0.000\t0.000\t0.103\t0.000\t0.000\t0.000\t0.000\t0.000\t0.221\t0.015\t0.026\t0.000", 
                               "219\t3.238\t2.405\t68\t197\t\t0.000\t0.003\t-0.000\t0.000\t0.000\t0.003\t0.234\t0.439\t0.003\t0.026\t0.000\t0.001\t0.000\t0.035\t0.000\t0.000\t-0.000\t0.000\t0.009\t0.046\t0.002\t0.004\t0.193", 
                               "220\t4.360\t1.250\t68\t172\t\t0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.020\t0.012\t0.005\t0.042\t0.007\t0.000\t0.000\t0.271\t-0.000\t0.021\t-0.000\t-0.000\t0.035\t0.585\t0.000\t-0.000\t0.000", 
                               "221\t2.052\t2.211\t91\t189\t\t0.000\t0.000\t0.328\t0.000\t-0.000\t0.000\t0.020\t0.031\t0.000\t0.023\t0.000\t0.011\t0.008\t0.019\t0.000\t0.001\t0.000\t-0.000\t0.498\t0.047\t0.000\t0.000\t0.014", 
                               "222\t3.227\t0.404\t27\t109\t\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.023\t0.013\t0.001\t0.005\t0.000\t0.000\t0.000\t0.304\t-0.000\t0.000\t-0.000\t-0.000\t0.000\t0.655\t-0.000\t-0.000\t0.000", 
                               "223\t3.541\t1.170\t52\t170\t\t0.003\t0.000\t-0.000\t-0.000\t-0.000\t0.001\t0.047\t0.141\t0.000\t0.002\t0.000\t0.026\t0.000\t0.120\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.400\t0.000\t-0.000\t0.262", 
                               "224\t2.155\t1.135\t30\t94\t\t-0.000\t-0.000\t0.000\t0.313\t-0.000\t0.000\t0.064\t0.050\t0.004\t0.112\t0.093\t0.000\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.042\t0.272\t0.049\t-0.000", 
                               "225\t3.620\t0.642\t55\t171\t\t0.000\t0.000\t0.000\t0.205\t0.000\t-0.000\t0.198\t0.404\t0.001\t0.018\t0.025\t0.014\t0.001\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.011\t0.022\t0.092\t0.008\t0.000", 
                               "226\t2.633\t1.870\t41\t147\t\t0.000\t0.000\t0.000\t0.086\t0.002\t-0.000\t0.291\t0.097\t0.001\t0.012\t0.010\t0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.293\t0.064\t0.144\t-0.000", 
                               "227\t3.000\t0.000\t8\t62\t\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.483\t0.517\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.000", 
                               "228\t1.000\t0.000\t2\t87\t\t-0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t-0.000\t0.000\t0.500\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.500\t-0.000\t-0.000\t-0.000", 
                               "229\t2.975\t1.775\t31\t157\t\t0.003\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.097\t0.155\t0.000\t0.000\t0.177\t0.092\t0.012\t0.001\t0.000\t0.000\t0.000\t0.000\t0.195\t0.269\t-0.000\t0.000\t0.000", 
                               "231\t2.743\t1.535\t17\t111\t\t0.011\t0.000\t0.000\t0.000\t0.000\t0.000\t0.166\t0.174\t-0.000\t0.000\t-0.000\t0.250\t0.000\t0.002\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.396\t0.000\t0.000\t0.000", 
                               "233\t1.925\t1.682\t20\t150\t\t0.000\t0.000\t0.000\t0.001\t-0.000\t0.000\t0.017\t0.283\t0.001\t0.000\t0.001\t0.109\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.587\t0.000\t0.000", 
                               "234\t2.181\t1.414\t20\t103\t\t-0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.061\t0.118\t0.006\t0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t-0.000\t0.000\t0.460\t0.355\t-0.000\t-0.000", 
                               "235\t2.773\t1.503\t62\t223\t\t0.000\t0.000\t0.000\t0.000\t0.029\t0.002\t0.113\t0.441\t0.001\t0.000\t0.000\t0.036\t-0.000\t0.001\t0.001\t0.000\t0.034\t0.000\t-0.000\t0.102\t0.091\t0.000\t0.148", 
                               "236\t1.600\t0.240\t9\t195\t\t-0.000\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.063\t-0.000\t0.164\t0.063\t-0.000\t0.000\t0.000\t0.188\t0.000\t0.000\t0.000\t0.310\t0.212\t0.000\t0.000", 
                               "237\t2.477\t2.445\t60\t205\t\t0.001\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.028\t0.103\t0.000\t0.000\t0.026\t0.504\t0.002\t0.002\t0.000\t-0.000\t0.022\t0.000\t0.029\t0.146\t0.114\t0.000\t0.022", 
                               "238\t1.000\t0.000\t1\t20\t\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t1.000\t-0.000\t0.000\t-0.000", 
                               "239\t2.537\t1.249\t44\t134\t\t0.003\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.041\t0.096\t0.000\t0.000\t0.000\t0.279\t0.000\t0.007\t0.000\t0.000\t0.084\t0.000\t-0.000\t0.405\t0.000\t0.000\t0.086", 
                               "240\t1.580\t0.244\t4\t78\t\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.580\t-0.000\t-0.000\t-0.000\t-0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.420\t-0.000", 
                               "241\t3.204\t1.348\t84\t187\t\t0.000\t0.000\t-0.000\t0.011\t0.000\t0.001\t0.096\t0.149\t0.000\t0.405\t0.001\t0.002\t0.009\t0.002\t0.000\t-0.000\t-0.000\t-0.000\t0.102\t0.001\t0.005\t0.213\t0.000", 
                               "243\t2.890\t2.449\t54\t220\t\t0.001\t0.003\t-0.000\t0.000\t0.006\t0.003\t0.242\t0.236\t0.000\t0.006\t0.000\t0.018\t-0.000\t0.037\t0.000\t0.000\t0.000\t0.000\t0.000\t0.017\t0.000\t0.219\t0.213", 
                               "244\t3.427\t2.966\t64\t255\t\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.001\t0.001\t0.003\t0.202\t0.165\t0.002\t0.028\t0.124\t0.000\t-0.000\t0.000\t-0.000\t0.016\t0.343\t0.000\t0.112\t0.000", 
                               "245\t1.859\t2.323\t53\t192\t\t0.001\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.026\t0.035\t0.000\t0.000\t0.024\t0.038\t0.355\t0.005\t-0.000\t0.000\t-0.000\t-0.000\t0.388\t0.067\t0.000\t-0.000\t0.062", 
                               "246\t2.338\t2.766\t38\t248\t\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.007\t0.007\t0.000\t0.000\t0.000\t0.013\t0.000\t0.324\t-0.000\t0.000\t-0.000\t0.000\t-0.000\t0.431\t-0.000\t0.187\t0.032", 
                               "247\t3.044\t1.563\t43\t154\t\t0.006\t0.000\t0.000\t-0.000\t0.000\t0.001\t0.085\t0.091\t0.000\t0.000\t0.000\t0.168\t-0.000\t0.032\t0.000\t0.000\t-0.000\t0.000\t-0.000\t0.203\t-0.000\t0.000\t0.414", 
                               "248\t1.535\t0.642\t6\t98\t\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.000\t0.197\t0.000\t-0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.661\t0.142\t0.000", 
                               "249\t2.540\t2.079\t62\t238\t\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.028\t0.019\t0.159\t0.001\t0.070\t0.001\t0.062\t0.016\t0.003\t-0.000\t-0.000\t-0.000\t0.000\t0.014\t0.000\t0.280\t0.040\t0.308", 
                               "250\t2.395\t2.419\t62\t221\t\t0.000\t0.000\t-0.000\t-0.000\t-0.000\t0.003\t0.081\t0.067\t0.003\t0.044\t0.000\t0.000\t-0.000\t0.072\t-0.000\t0.000\t0.000\t0.123\t-0.000\t0.096\t0.150\t0.206\t0.154", 
                               "252\t2.901\t0.872\t86\t243\t\t0.000\t0.000\t-0.000\t0.000\t-0.000\t0.000\t0.001\t0.001\t0.055\t0.108\t0.058\t0.082\t0.021\t0.206\t-0.000\t0.001\t0.000\t0.000\t0.002\t0.034\t0.354\t0.076\t0.000", 
                               "253\t2.285\t0.502\t38\t203\t\t0.000\t0.000\t0.000\t0.000\t0.000\t0.002\t0.000\t0.003\t0.000\t0.000\t-0.000\t0.298\t0.198\t0.058\t0.000\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.440", 
                               "254\t2.591\t1.049\t45\t180\t\t0.000\t0.000\t-0.000\t-0.000\t0.000\t0.000\t0.005\t0.004\t0.000\t0.001\t0.000\t0.018\t-0.000\t0.348\t-0.000\t0.000\t0.000\t0.000\t-0.000\t0.434\t0.000\t-0.000\t0.189", 
                               "255\t1.307\t0.534\t35\t115\t\t0.000\t0.000\t0.000\t-0.000\t-0.000\t0.002\t0.000\t0.003\t0.000\t0.000\t0.000\t0.083\t-0.000\t0.063\t0.000\t0.000\t-0.000\t0.000\t0.000\t0.000\t0.000\t-0.000\t0.850", 
                               "", "", "/* Summary adaptive walk statistics */", "Mean E[steps]: 2.561\tStdev E[steps]: 0.904\tMean V[steps]: 1.178\tStdev V[steps]: 0.967\tMean Reachability: 31.858\tStdev Reachability: 23.692\tMean FitterG: 136.215\tStdev FitterG: 70.986\tMean P[7]: 0.019\tVar P[7]: 0.059\tMean P[17]: 0.022\tVar P[17]: 0.069\tMean P[29]: 0.028\tVar P[29]: 0.107\tMean P[32]: 0.051\tVar P[32]: 0.140\tMean P[35]: 0.017\tVar P[35]: 0.055\tMean P[59]: 0.015\tVar P[59]: 0.062\tMean P[66]: 0.129\tVar P[66]: 0.164\tMean P[75]: 0.166\tVar P[75]: 0.214\tMean P[76]: 0.023\tVar P[76]: 0.060\tMean P[80]: 0.051\tVar P[80]: 0.131\tMean P[100]: 0.032\tVar P[100]: 0.084\tMean P[109]: 0.047\tVar P[109]: 0.134\tMean P[117]: 0.016\tVar P[117]: 0.075\tMean P[118]: 0.104\tVar P[118]: 0.180\tMean P[137]: 0.018\tVar P[137]: 0.079\tMean P[172]: 0.016\tVar P[172]: 0.075\tMean P[175]: 0.009\tVar P[175]: 0.048\tMean P[186]: 0.008\tVar P[186]: 0.037\tMean P[213]: 0.018\tVar P[213]: 0.071\tMean P[230]: 0.152\tVar P[230]: 0.231\tMean P[232]: 0.025\tVar P[232]: 0.087\tMean P[242]: 0.014\tVar P[242]: 0.050\tMean P[251]: 0.021\tVar P[251]: 0.085"
                               )
                             )
    
    ## cat("which differ")     
    ## print(which(s9l_compare != s9l))
    ## cat("done which differ")
    ## position 21 differs in Windoze and Mac
    expect_identical(s9s[-21], s9s_compare[-21])
    ## Go figure, a bunch of lines differ in Windows and Mac
    ## and also after we add new code to the freq-dep-fitness branch
    skip_on_os(c("windows", "mac"))
    expect_identical(s9l[1:896], s9l_compare[1:896])
    
    #skip_on_os(c("windows", "mac"))
    #expect_identical(s9l[902:1133], s9l_compare[902:1133])
    
})



set.seed(NULL)
cat(paste("\n Ended test.Z-magellan at", date(), "\n"))
