% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDoc.R
\docType{data}
\name{hp_ancestors}
\alias{hp_ancestors}
\title{HP ancestors (Example data)}
\format{A named list of 10962 character vectors.}
\source{
\url{http://compbio.charite.de/hudson/job/hpo/1529/artifact/hp/hp.obo}
}
\description{
HP terms which are ancestors of each HP term
(including itself) in the Human Phenotype Ontology
(\url{http://www.human-phenotype-ontology.org/}).
Only descendants of 'Phenotypic abnormality' were taken into account.
}
\details{
These data are used to examplify the different functions of
the package.
More data are available in the MultiHumanPhenoDB package.
}
\examples{
## Prerequisite
data(geneByHp, hp_descendants, package="PCAN")
geneByHp <- unstack(geneByHp, entrez~hp)
ic <- computeHpIC(geneByHp, hp_descendants)

## Compute similarity between different couples of HP terms
data(hp_ancestors, hpDef, package="PCAN")
hp1 <- "HP:0000518"
hp2 <- "HP:0030084"
hp3 <- "HP:0002119"
hp4 <- "HP:0001305"
hpDef[which(hpDef$id \%in\% c(hp1, hp2)), 1:2]
calcHpSim(hp1, hp2, IC=ic, ancestors=hp_ancestors)
hpDef[which(hpDef$id \%in\% c(hp2, hp3)), 1:2]
calcHpSim(hp2, hp3, IC=ic, ancestors=hp_ancestors)
hpDef[which(hpDef$id \%in\% c(hp2, hp4)), 1:2]
calcHpSim(hp2, hp4, IC=ic, ancestors=hp_ancestors)
hpDef[which(hpDef$id \%in\% c(hp3, hp4)), 1:2]
calcHpSim(hp3, hp4, IC=ic, ancestors=hp_ancestors)
}

