% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDoc.R
\docType{data}
\name{hqStrNw}
\alias{hqStrNw}
\title{STRIND database network of Homo sapiens genes (Example data)}
\format{A data frame of 643683 and 3 columns:
\describe{
\item{gene1}{Entrez gene IDs.}
\item{gene2}{Entrez gene IDs.}
\item{upstream}{TRUE if the directionality of the interaction
between the 2 genes is known. In this case gene1 is upstream gene 2.}
}}
\source{
Different ressources were used in June 2 2015: \itemize{
\item{
\url{http://string-db.org/newstring_download/protein.actions.v10/9606.protein.actions.v10.txt.gz}
was used to get the network of Ensembl protein IDs.
Only interaction with a score greater or equal to 500 were kept.}
\item{BioMart from \url{http://jan2013.archive.ensembl.org/index.html}
was used to map Ensembl protein IDs to Ensembl gene IDs.
Ensembl gene IDs were mapped to Entrez gene IDs using this
ressource in addition to
\url{ftp://ftp.ncbi.nih.gov/gene/DATA/gene2ensembl.gz}}
}
}
\description{
A network of human entrez gene IDs taken from
the STRING database.
}
\examples{
\dontrun{example(hpGeneListComp)}
}

