% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-trainModel.R
\name{trainModel,RGAModel-method}
\alias{trainModel,RGAModel-method}
\title{Train a RGAModel Based on the Data in the assays slot.}
\usage{
\S4method{trainModel}{RGAModel}(object, numModels = 10, minAccuracy = 0, ...)
}
\arguments{
\item{object}{A \code{RGAmodel} object to train.}

\item{numModels}{An \code{integer} specifying the number of models to train.
Defaults to 10. We recommend using 1000+ for good results.}

\item{minAccuracy}{A \code{float} specifying the balanced accuracy required
to consider a model 'top scoring'. Defaults to 0. Must be in the
range 0 to 1.}

\item{...}{Fall through arguments to \code{BiocParallel::bplapply}.}
}
\value{
A \code{RGAModel} object with the trained model in the \code{model} slot.
}
\description{
Uses the switchBox SWAP.Train.KTSP function to fit a number of k top scoring
pair models to the data, filtering the results to the best models based
on the specified paramters.
}
\details{
This function is parallelized with BiocParallel, thus if you wish
to change the back-end for parallelization, number of threads, or any
other parallelization configuration please pass BPPARAM to bplapply.
}
\examples{
data(sampleRGAmodel)
set.seed(getModelSeed(sampleRGAmodel))

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

trainedRGAmodel <- trainModel(sampleRGAmodel, numModels=2, minAccuracy=0)

}
\seealso{
\code{switchBox::SWAP.KTSP.Train} \code{BiocParallel::bplapply}
}
