% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-validateModel.R
\name{validateModel,ClinicalModel,CohortList-method}
\alias{validateModel,ClinicalModel,CohortList-method}
\title{Evaluate the Performance of a List of Trained KTSP Models from a PCOSP
Model}
\usage{
\S4method{validateModel}{ClinicalModel,CohortList}(model, valData, ...)
}
\arguments{
\item{model}{A trained \code{ClinicalModel} object, as returned by the \code{trainModel}
method.}

\item{valData}{A \code{CohortList} containing one or more
\code{SurvivalExperiment}s. The first assay in each \code{SurvivalExperiment} will
be classified using all top scoring KTSP models in \code{models(model)}.}

\item{...}{Fallthrough arguments to \code{BiocParallel::bplapply}, use this to
configure the parallelization settings for this function. For example
to specify BPARAM.}
}
\value{
The \code{model} object with the validationStats and validationData
slots occupied.
}
\description{
Evaluate the Performance of a List of Trained KTSP Models from a PCOSP
Model
}
\examples{
data(sampleClinicalModel)
data(samplePCSIsurvExp)

# Set parallelization settings
BiocParallel::register(BiocParallel::SerialParam())

# Train Model
trainedClinicalModel <- trainModel(sampleClinicalModel)

# Make predictions
clinicalPredSurvExp <- predictClasses(samplePCSIsurvExp,
  model=trainedClinicalModel)

# Validate model
validatedClincalModel <- validateModel(trainedClinicalModel,
  valData=clinicalPredSurvExp)

}
\seealso{
\code{\link[BiocParallel:bplapply]{BiocParallel::bplapply}}, \code{\link[switchBox:SWAP.KTSP.Classify]{switchBox::SWAP.KTSP.Classify}}
}
