% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PICBexporttoexcel.R
\name{PICBexporttoexcel}
\alias{PICBexporttoexcel}
\title{Export cluster object into an Excel file}
\usage{
PICBexporttoexcel(IN.RANGES = NULL, EXCEL.FILE.NAME = NULL)
}
\arguments{
\item{IN.RANGES}{clustering object to export}

\item{EXCEL.FILE.NAME}{file name to save}
}
\value{
no values returned
}
\description{
Export cluster object into an Excel file
}
\examples{
library(BSgenome.Dmelanogaster.UCSC.dm6)
myAlignmentsFromPICBload <- PICBload(
    BAMFILE = system.file("extdata", "Fly_Ov1_chr2L_20To21mb_filtered.bam", package = "PICB"),
    REFERENCE.GENOME = "BSgenome.Dmelanogaster.UCSC.dm6",
    VERBOSE = FALSE
)

outputOfPICBbuild <- PICBbuild(
    IN.ALIGNMENTS = myAlignmentsFromPICBload,
    REFERENCE.GENOME = "BSgenome.Dmelanogaster.UCSC.dm6",
    LIBRARY.SIZE = 12799826, #usually not necessary
    VERBOSITY = 0
)
PICBexporttoexcel(
    IN.RANGES = outputOfPICBbuild,
    EXCEL.FILE.NAME = "inst/extdata/myClusters_demonstration.xlsx"
)
}
\author{
Aleksandr Friman

Franziska Ahrend
}
