% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaDensity.R
\name{PomaDensity}
\alias{PomaDensity}
\title{Density Plots}
\usage{
PomaDensity(
  data,
  x = "samples",
  outcome = NULL,
  feature_name = NULL,
  theme_params = list(legend_title = FALSE)
)
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{x}{Character. Options are "samples" (to visualize sample density plots) and "features" (to visualize feature density plots). Default is "samples".}

\item{outcome}{Character. Indicates the name of the \code{colData} column to be used as the outcome factor. Default is NULL (first factor variable in \code{colData}).}

\item{feature_name}{Character vector. Indicates the feature/s to display. Default is NULL (all features will be displayed).}

\item{theme_params}{List. Indicates \code{theme_poma} parameters.}
}
\value{
A \code{ggplot} object.
}
\description{
\code{PomaDensity} generates a density plot for samples and features. This function can be used for data exploration (e.g., comparison between pre and post normalized datasets).
}
\examples{
data <- POMA::st000284 \%>\% # Example SummarizedExperiment object included in POMA
  PomaNorm() 

# Sample density plots
data \%>\%
  PomaDensity(x = "samples",
              outcome = NULL)

# Sample density plots with covariate as outcome
data \%>\%
  PomaDensity(x = "samples",
              outcome = "gender") # change outcome

# All feature density plots
data \%>\%
  PomaDensity(x = "features",
              theme_params = list(legend_position = "none"))

# Specific feature density plots
data \%>\% 
  PomaDensity(x = "features", 
              feature_name = c("ornithine", "orotate"))
}
\author{
Pol Castellano-Escuder
}
