% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PomaOddsRatio.R
\name{PomaOddsRatio}
\alias{PomaOddsRatio}
\title{Logistic Regression Model Odds Ratios}
\usage{
PomaOddsRatio(data, feature_name = NULL, covs = NULL, show_ci = TRUE)
}
\arguments{
\item{data}{A \code{SummarizedExperiment} object.}

\item{feature_name}{Character vector. Indicates the name/s of feature/s that will be used to fit the model. If it's NULL (default), all variables will be included in the model.}

\item{covs}{Character vector. Indicates the names of \code{colData} columns to be included as covariates. Default is NULL (no covariates).}

\item{show_ci}{Logical. Indicates if the 95\% confidence intervals will be plotted. Default is \code{TRUE}.}
}
\value{
A \code{list} with results including plots and tables.
}
\description{
\code{PomaOddsRatio} calculates the Odds Ratios for each feature from a logistic regression model using the binary outcome (group/type must be a binary factor) as a dependent variable.
}
\examples{
data <- POMA::st000336 \%>\% # Example SummarizedExperiment object included in POMA
  PomaImpute() \%>\% 
  PomaNorm()

## Output is a list with objects `odds_ratio_table` (tibble) and `odds_ratio_plot` (ggplot2 object)
data \%>\% 
  PomaOddsRatio(feature_name = c("glutamic_acid", "glutamine", "glycine", "histidine"),
                covs = NULL, 
                show_ci = TRUE)

# With covariates
data \%>\% 
  PomaOddsRatio(feature_name = c("glutamic_acid", "glutamine", "glycine", "histidine"),
                covs = "steroids", 
                show_ci = TRUE)
}
\author{
Pol Castellano-Escuder
}
