% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterProteins.R
\name{filter_out_NA_proteins_by_threshold}
\alias{filter_out_NA_proteins_by_threshold}
\title{Filter proteins based on their NA pattern using a specific threshold}
\usage{
filter_out_NA_proteins_by_threshold(se, thr = 0.8)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomics data set}

\item{thr}{Threshold for the minimum fraction of valid values allowed for any protein}
}
\value{
filtered SummarizedExperiment object
}
\description{
Filter proteins based on their NA pattern using a specific threshold
}
\examples{
data(tuberculosis_TMT_se)
tuberculosis_TMT_se <- filter_out_NA_proteins_by_threshold(tuberculosis_TMT_se,
                                                       thr = 0.8)

}
