% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NormalizationMethods.R
\name{normicsNorm}
\alias{normicsNorm}
\title{Normics Normalization (Normics using VSN or using Median)}
\usage{
normicsNorm(
  se,
  ain = "raw",
  aout = "NormicsVSN",
  method = "NormicsVSN",
  on_raw = TRUE,
  reduce_correlation_by = 1,
  NormicsVSN_quantile = 0.8,
  TMT_ratio = FALSE,
  top_x = 50
)
}
\arguments{
\item{se}{SummarizedExperiment containing all necessary information of the proteomic dataset}

\item{ain}{String which assay should be used as input}

\item{aout}{String which assay should be used to save normalized data}

\item{method}{String specifying the method to use (NORMICS or NORMICSmedian)}

\item{on_raw}{Boolean specifying whether normalization should be performed on raw or log2-scaled data}

\item{reduce_correlation_by}{If the data is too big for the computation of the params, increase this parameter by 2,3,4.... The whole data will still be normalized, but the params are calculated on every second row etc.}

\item{NormicsVSN_quantile}{The quantile that is used for the resistant least trimmed sum of squares regression. A value of 0.8 means focusing on the central 80\% of the data, reducing the influence of outliers.}

\item{TMT_ratio}{Indicates if the data involves Tandem Mass Tag (TMT) ratio-based measurements (common in proteomics). If TRUE, the method may handle the data differently.}

\item{top_x}{Number of reference proteins extracted for the calculation of parameters}
}
\value{
SummarizedExperiment containing the NormicsVSN/NormicsMedian normalized data as assay (on log2 scale)
}
\description{
Log2-scaled data should be used as input (on_raw = FALSE).
}
\examples{
data(tuberculosis_TMT_se)
tuberculosis_TMT_se <- normicsNorm(tuberculosis_TMT_se, ain = "raw",
                                aout = "NormicsVSN", method = "NormicsVSN",
                                on_raw = TRUE)


}
