% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/best_hint.R
\name{eval_perm}
\alias{eval_perm}
\title{Evaluate a permutation of founder mothers}
\usage{
eval_perm(idx, fmom, pmat, obj, n, wt, align_parents, force)
}
\arguments{
\item{idx}{The index of the permutation to evaluate}

\item{fmom}{The vector of founder mother indices}

\item{pmat}{The matrix of permutations of founder mothers}

\item{obj}{A Pedigree object}

\item{n}{The number of individuals in the Pedigree}

\item{wt}{A vector of three weights for the three error measures.
Default is \code{c(1000, 10, 1)}.
\enumerate{
\item The number of duplicate individuals in the plot
\item The sum of the absolute values of the differences in the
positions of duplicate individuals
\item The sum of the absolute values of the differences between
the center of the children and the parents.
}}

\item{align_parents}{If \code{align_parents = TRUE}, go one step further
and try to make both parents of each child have the same depth.
(This is not always possible).
It helps the drawing program by lining up pedigrees that
'join in the middle' via a marriage.}

\item{force}{If \code{force = TRUE}, the function will return the depth minus
\code{min(depth)} if \code{depth} reach a state with no founders
is not possible.}
}
\value{
The stress value of the hint and the new hint
}
\description{
This is a helper function for \code{\link[=best_hint]{best_hint()}}.
It evaluates a permutation of founder mothers
by creating a new hint
and computing the stress of the hint.
}
\examples{
data(sampleped)
pedi <- Pedigree(sampleped[sampleped$famid == 1,])
newhint <- auto_hint(pedi, align_parents = TRUE)
Pedixplorer:::compute_stress(pedi, newhint)
}
\seealso{
\code{\link[=best_hint]{best_hint()}}, \code{\link[=align]{align()}}
}
\keyword{internal}
