% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{is_founder}
\alias{is_founder}
\title{Are individuals founders}
\usage{
is_founder(momid, dadid, missid = NA_character_)
}
\arguments{
\item{momid}{A vector containing for each subject, the identifiers of the
biologicals mothers.}

\item{dadid}{A vector containing for each subject, the identifiers of the
biologicals fathers.}

\item{missid}{A character vector with the missing values identifiers.
All the id, dadid and momid corresponding to those values will be set
to \code{NA_character_}.}
}
\value{
A vector of boolean of the same size as \strong{dadid} and \strong{momid}
with \code{TRUE} if the individual has no parents (i.e is a founder) and
\code{FALSE} otherwise.
}
\description{
Check which individuals are founders.
}
\examples{
is_founder(c("3", "3", NA, NA), c("4", "4", NA, NA))
}
\keyword{internal}
