% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_informative.R
\docType{methods}
\name{is_informative}
\alias{is_informative}
\alias{is_informative,character_OR_integer-method}
\alias{is_informative,Ped-method}
\alias{is_informative,Pedigree-method}
\title{Find informative individuals}
\usage{
\S4method{is_informative}{character_OR_integer}(obj, avail, affected, informative = "AvAf")

\S4method{is_informative}{Ped}(obj, informative = "AvAf", reset = FALSE)

\S4method{is_informative}{Pedigree}(obj, col_aff = NULL, informative = "AvAf", reset = FALSE)
}
\arguments{
\item{obj}{A character vector with the id of the individuals or a
\code{data.frame} with all the informations in corresponding columns.}

\item{avail}{A logical vector with the availability status of the
individuals
(i.e. \code{FALSE} = not available,
\code{TRUE} = available,
\code{NA} = unknown).}

\item{affected}{A logical vector with the affection status of the
individuals
(i.e. \code{FALSE} = unaffected,
\code{TRUE} = affected,
\code{NA} = unknown).}

\item{informative}{Informative individuals selection can take 5 values:
\itemize{
\item 'AvAf' (available and affected),
\item 'AvOrAf' (available or affected),
\item 'Av' (available only),
\item 'Af' (affected only),
\item 'All' (all individuals)
\item A numeric/character vector of individuals id
\item A boolean
}}

\item{reset}{If \code{TRUE}, the \code{isinf} slot is reset}

\item{col_aff}{A character vector with the name of the column to be used
for the affection status.}
}
\value{
\subsection{When obj is a vector}{

A vector of individuals informative identifiers.
}

\subsection{When obj is a Pedigree}{

The Pedigree object with its \code{isinf} slot updated.
}
}
\description{
Select the ids of the informative individuals.
}
\details{
Depending on the \strong{informative} parameter, the function will
extract the ids of the informative individuals. In the case of a
numeric vector, the function will return the same vector.
In the case of a boolean, the function will return the ids of the
individuals if TRUE, NA otherwise.
In the case of a string, the function will return the ids of the
corresponding informative individuals based on the avail and affected
columns.
}
\examples{
is_informative(c("A", "B", "C", "D", "E"), informative = c("A", "B"))
is_informative(c("A", "B", "C", "D", "E"), informative = c(1, 2))
is_informative(c("A", "B", "C", "D", "E"), informative = c("A", "B"))
is_informative(c("A", "B", "C", "D", "E"), avail = c(1, 0, 0, 1, 1),
    affected = c(0, 1, 0, 1, 1), informative = "AvAf")
is_informative(c("A", "B", "C", "D", "E"), avail = c(1, 0, 0, 1, 1),
    affected = c(0, 1, 0, 1, 1), informative = "AvOrAf")
is_informative(c("A", "B", "C", "D", "E"),
    informative = c(TRUE, FALSE, TRUE, FALSE, TRUE))

data("sampleped")
pedi <- ped(Pedigree(sampleped))
pedi <- is_informative(pedi, informative = "Av")
isinf(pedi)

data("sampleped")
pedi <- Pedigree(sampleped)
pedi <- is_informative(pedi, col_aff = "affection")
isinf(ped(pedi))
}
