% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped_to_plotdf.R
\name{ped_to_plotdf}
\alias{ped_to_plotdf}
\alias{ped_to_plotdf,Pedigree-method}
\title{Create plotting data frame from a Pedigree}
\usage{
\S4method{ped_to_plotdf}{Pedigree}(
  obj,
  packed = TRUE,
  width = 6,
  align = c(1.5, 2),
  align_parents = TRUE,
  force = FALSE,
  cex = 1,
  symbolsize = cex,
  pconnect = 0.5,
  branch = 0.6,
  aff_mark = TRUE,
  id_lab = "id",
  label = NULL,
  precision = 4,
  lwd = 1,
  tips = NULL,
  ggplot_gen = FALSE,
  label_dist = c(1, 3, 5),
  label_cex = c(1, 0.7, 1),
  ...
)
}
\arguments{
\item{obj}{A Pedigree object}

\item{...}{Other arguments passed to \code{\link[=par]{par()}}}

\item{packed}{Should the Pedigree be compressed.
(i.e. allow diagonal lines connecting parents to children in order
to have a smaller overall width for the plot.)}

\item{width}{For a packed output, the minimum width of the plot, in
inches.}

\item{align}{For a packed Pedigree, align children under parents \code{TRUE},
to the extent possible given the page width, or align to to the left
margin \code{FALSE}.
This argument can be a two element vector, giving the alignment
parameters, or a logical value.
If \code{TRUE}, the default is \code{c(1.5, 2)}, or if numeric the routine
\code{alignped4()} will be called.}

\item{align_parents}{If \code{align_parents = TRUE}, go one step further
and try to make both parents of each child have the same depth.
(This is not always possible).
It helps the drawing program by lining up pedigrees that
'join in the middle' via a marriage.}

\item{force}{If \code{force = TRUE}, the function will return the depth minus
\code{min(depth)} if \code{depth} reach a state with no founders
is not possible.}

\item{cex}{Character expansion of the text}

\item{symbolsize}{Size of the symbols}

\item{pconnect}{When connecting parent to children the program will try to
make the connecting line as close to vertical as possible, subject to it
lying inside the endpoints of the line that connects the children by at
least \code{pconnect} people.  Setting this option to a large number will
force the line to connect at the midpoint of the children.}

\item{branch}{defines how much angle is used to connect various levels of
nuclear families.}

\item{aff_mark}{If \code{TRUE}, add a aff_mark to each box corresponding to the
value of the affection column for each filling scale.}

\item{id_lab}{The column name of the id for each individuals.}

\item{label}{If not \code{NULL}, add a label to each box under the id
corresponding to the value of the column given.}

\item{precision}{The number of significatif numbers to round the
solution to.}

\item{lwd}{default=1. Controls the line width of the
segments, arcs and polygons.}

\item{tips}{A character vector of the column names of the data frame to
use as tooltips. If \code{NULL}, no tooltips are added.}

\item{ggplot_gen}{If \code{TRUE}, the function will use the
\code{ggplot2} package to generate the plot.}

\item{label_dist}{A numeric vector of length 3 giving the distance
between the id, date and label text and the bottom of the box.
This value is multiplied by the obtained \code{labh} value.}

\item{label_cex}{A numeric vector of length 3 giving the cex of the id,
date and label text. This value is multiplied by the \code{cex} argument}
}
\value{
A list containing the data frame and the user coordinates.
}
\description{
Convert a Pedigree to a data frame with all the elements and their
characteristic for them to be plotted afterwards with
\code{\link[=plot_fromdf]{plot_fromdf()}}.
}
\details{
The data frame contains the following columns:
\itemize{
\item \code{x0}, \code{y0}, \code{x1}, \code{y1}: coordinates of the elements
\item \code{type}: type of the elements
\item \code{fill}: fill color of the elements
\item \code{border}: border color of the elements
\item \code{angle}: angle of the shading of the elements
\item \code{density}: density of the shading of the elements
\item \code{cex}: size of the elements
\item \code{label}: label of the elements
\item \code{tips}: tips of the elements (used for the tooltips)
\item \code{adjx}: horizontal text adjustment of the labels
\item \code{adjy}: vertical text adjustment of the labels
}

All those columns are used by
\code{\link[=plot_fromdf]{plot_fromdf()}} to plot the graph.
}
\examples{

data(sampleped)
ped1 <- Pedigree(sampleped[sampleped$famid == 1,])
plot_df <- ped_to_plotdf(ped1)
summary(plot_df$df)
plot_fromdf(plot_df$df, usr = plot_df$par_usr$usr,
    boxh = plot_df$par_usr$boxh, boxw = plot_df$par_usr$boxw
)
}
\seealso{
\code{\link[=plot_fromdf]{plot_fromdf()}}
\code{\link[=ped_to_legdf]{ped_to_legdf()}}
}
\keyword{Pedigree-plot}
\keyword{internal,}
