% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PharmacoSet-class.R
\docType{class}
\name{PharmacoSet-class}
\alias{PharmacoSet-class}
\alias{.PharmacoSet}
\title{A Class to Contain PharmacoGenomic datasets together with their curations}
\arguments{
\item{object}{A \code{PharmacoSet} object}

\item{mDataType}{A \code{character} with the type of molecular data to
return/update}

\item{value}{A replacement value}
}
\value{
An object of the PharmacoSet class
}
\description{
The PharmacoSet (pSet) class was developed to contain and organise large
PharmacoGenomic datasets, and aid in their metanalysis. It was designed
primarily to allow bioinformaticians and biologists to work with data at the
level of genes, drugs and cell lines, providing a more naturally intuitive
interface and simplifying analyses between several datasets. As such, it was
designed to be flexible enough to hold datasets of two different natures
while providing a common interface. The class can accomidate datasets
containing both drug dose response data, as well as datasets contaning
genetic profiles of cell lines pre and post treatement with compounds, known
respecitively as sensitivity and perturbation datasets.
}
\section{Slots}{

\describe{
\item{\code{annotation}}{A \code{list} of annotation data about the PharmacoSet,
including the \code{$name} and the session information for how the object
was creating, detailing the exact versions of R and all the packages used}

\item{\code{molecularProfiles}}{A \code{list} containing \code{SummarizedExperiment}
type object for holding data for RNA, DNA, SNP and CNV
measurements, with associated \code{fData} and \code{pData}
containing the row and column metadata}

\item{\code{sample}}{A \code{data.frame} containing the annotations for all the cell
lines profiled in the data set, across all data types}

\item{\code{treatment}}{A \code{data.frame} containg the annotations for all the drugs
profiled in the data set, across all data types}

\item{\code{treatmentResponse}}{A \code{list} containing all the data for the
sensitivity experiments, including \code{$info}, a \code{data.frame}
containing the experimental info,\code{$raw} a 3D \code{array} containing
raw data, \code{$profiles}, a \code{data.frame} containing sensitivity
profiles statistics, and \code{$n}, a \code{data.frame} detailing the
number of experiments for each cell-drug pair}

\item{\code{perturbation}}{A \code{list} containting \code{$n}, a \code{data.frame}
summarizing the available perturbation data,}

\item{\code{curation}}{A \code{list} containing mappings for \code{$treatment},
\code{cell}, \code{tissue} names  used in the data set to universal
identifiers used between different PharmacoSet objects}

\item{\code{datasetType}}{A \code{character} string of 'sensitivity',
'perturbation', or both detailing what type of data can be found in the
PharmacoSet, for proper processing of the data}
}}

