% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callingWaterfall.R
\name{callingWaterfall}
\alias{callingWaterfall}
\title{Drug sensitivity calling using waterfall plots}
\usage{
callingWaterfall(
  x,
  type = c("IC50", "AUC", "AMAX"),
  intermediate.fold = c(4, 1.2, 1.2),
  cor.min.linear = 0.95,
  name = "Drug",
  plot = FALSE
)
}
\arguments{
\item{x}{What type of object does this take in?}

\item{type}{ic50: IC50 values in micro molar (positive values)
actarea: Activity Area, that is area under the drug activity curve (positive values)
amax: Activity at max concentration (positive values)}

\item{intermediate.fold}{vector of fold changes used to define the intermediate sensitivities for ic50, actarea and amax respectively}

\item{cor.min.linear}{\code{numeric} The minimum linear correlation to
require?}

\item{name}{\code{character} The name of the output to use in plot}

\item{plot}{\code{boolean} Whether to plot the results}
}
\value{
\code{factor} Containing the drug sensitivity status of each
sample.
}
\description{
\enumerate{
\item Sensitivity calls were made using one of IC50, ActArea or Amax
}
}
\details{
\enumerate{
\item Sort log IC50s (or ActArea or Amax) of the samples to generate a
“waterfall distribution”
\item Identify cutoff:
}

3.1 If the waterfall distribution is non-linear (pearson cc to the linear
fit <=0.95), estimate the major inflection point of the log IC50 curve as
the point on the curve with the maximal distance to a line drawn between
the start and end points of the distribution.

3.2 If the waterfall distribution appears linear (pearson cc to the linear
fit > 0.95), then use the median IC50 instead.
\enumerate{
\item Samples within a 4-fold IC50 (or within a 1.2-fold ActArea or 20\% Amax
difference) difference centered around this inflection point are classified
as being “intermediate”,  samples with lower IC50s (or ActArea/Amax
values) than this range are defined as sensitive, and those with IC50s (or
ActArea/Amax) higher than this range are called “insensitive”.
\item Require at least x sensitive and x insensitive samples after applying
these criteria (x=5 in our case).
}
}
\examples{
# Dummy example
1 + 1
}
