% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PhosphoExperiment.R
\docType{methods}
\name{PPE-operate}
\alias{PPE-operate}
\alias{[,PhosphoExperiment,ANY,ANY,ANY-method}
\alias{rbind}
\alias{cbind}
\alias{[}
\alias{[<-}
\alias{[<-,PhosphoExperiment,ANY,ANY,ANY-method}
\alias{rbind,PhosphoExperiment-method}
\alias{cbind,PhosphoExperiment-method}
\title{PhosphoExperiment object subset, combine methods}
\usage{
\S4method{[}{PhosphoExperiment,ANY,ANY,ANY}(x, i, j, drop = TRUE)

\S4method{[}{PhosphoExperiment,ANY,ANY,ANY}(x, i, j, ...) <- value

\S4method{rbind}{PhosphoExperiment}(..., deparse.level = 1)

\S4method{cbind}{PhosphoExperiment}(..., deparse.level = 1)
}
\arguments{
\item{x}{A  \code{PhosphoExperiment} object}

\item{i}{For \code{[,PhosphoExperiment}, \code{[,PhosphoExperiment<-, i, j} 
are subscripts that can act to subset the rows of x}

\item{j}{For \code{[,PhosphoExperiment}, \code{[,PhosphoExperiment<-, i, j} 
are subscripts that can act to subset the columns of x}

\item{drop}{A \code{logical(1)}, ignored by these methods}

\item{...}{In \code{cbind} or \code{rbind}, a \code{PhosphoExperiment} 
objects}

\item{value}{An object of a class specified in the S4 method signature.}

\item{deparse.level}{{See \code{?base::\link[base]{cbind}} for a description 
of this argument.}}
}
\description{
These are methods for combining or subsetting for  
\code{PhosphoExperiment} object. This provides some convenience for users.
}
\section{Available methods}{

 In the following code snippets, \code{ppe1} and \code{ppe2} is a 
 \code{PhosphoExperiment} object with matching \code{colData}. 
 \code{ppe3} and \code{ppe4} is a \code{PhosphoExperiment} object with 
 matching \code{rowData}.

\describe{
\item{\code{rbind(ppe1, ppe2)}:}{Combine row-wise}
\item{\code{cbind(ppe3, ppe4)}:}{Combine column-wise}
}
}

\examples{
example(PhosphoExperiment, echo = FALSE)

n = ncol(phosData)
ppe1 = phosData[,seq(round(n/2))]
ppe2 = phosData[,-seq(round(n/2))]

ppe = cbind(ppe1, ppe2)
identical(ppe, phosData)

ppe[,seq(round(n/2))] = ppe1
identical(ppe, phosData)

p = nrow(phosData)
ppe1 = phosData[seq(round(p/2)),]
ppe2 = phosData[-seq(round(p/2)),]

ppe = rbind(ppe1, ppe2)
identical(ppe, phosData)

ppe[seq(round(p/2)),] = ppe1
identical(ppe, phosData)

}
\seealso{
method \code{rbind}, \code{cbind} from 
\linkS4class{SummarizedExperiment} object.
}
\author{
Taiyun Kim
}
