% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/podcallDdpcr.R
\name{podcallDdpcr}
\alias{podcallDdpcr}
\title{Positive Droplet Calling for ddPCR}
\usage{
podcallDdpcr(dataDirectory,
                    sampleSheetFile=NULL,
                    B=200,
                    Q=9,
                    refwell=1,
                    targetChannel=c(1,2,3,4,5,6)[1],
                    controlChannel=c(1,2,3,4,5,6)[2],
                    nrChannels=c(1,2)[2],
                    software=c("QuantaSoft", "QX Manager")[2],
                    resultsToFile=FALSE,
                    plots=FALSE,
                    resPath=NULL)
}
\arguments{
\item{dataDirectory}{Path to directory containing QuantaSoft amplitude files
from one 96 well plate. Since well coordinates are used as identifiers,
files in this directory should all be from the same 96 well plate.
Furthermore, there can be no other files than the amplitude files from
a well plate in the directory.}

\item{sampleSheetFile}{File (optional) containing sample information from
ddPCR experiment. This file must be a comma separated file containing the
following columns: Well, Sample, TargetType and Target.}

\item{B}{The number of permutations used for the Likelihood Ratio Test
(default=200)}

\item{Q}{A parameter for calling outliers (default=9)}

\item{refwell}{reference well to calculate the shift in baseline (default=1)}

\item{targetChannel}{The channel nr used as target channel (default=1)}

\item{controlChannel}{The channel nr used as control channel (default=2)}

\item{nrChannels}{If single channel target and no control channel, set to 1,
if control channel is used, set to 2 (default=2)}

\item{software}{The software data was exported from, either QuntaSoft or
QXmanager. Needs to be specified to ensure correct reading of data and
sample sheet due to difference in formatting. (defult="QX Manager")}

\item{resultsToFile}{Should results be written to file(.csv)? (default=FALSE)}

\item{plots}{Should plots be created and written to file? (default=FALSE)}

\item{resPath}{Optional argument to provide results directory path
(default=NULL)}
}
\value{
The function returns a table (data frame) with thresholds,
    droplet counts, concentration and normalized concentration.
    The table is optionally written to a .csv-file and plots for both
    channels per well can be written to files.
}
\description{
Wrapper function that provide a complete workflow for the
    functionality of PoDCall. It takes path to amplitude files and sample
    sheet (optional), and parameters for setting threshold as input.
    Calls functions that read in data from files, sets threshold for each
    channel per well, calculates concentrations and optionally makes
    scatter plot and histogram for each channel per well.
    Results are returned as a table, optionally written to file.
    Plots will be written to file in a results directory if argument plots is
    set to TRUE.
}
\examples{

## Paths to data and sample sheet
dataPath <- system.file("extdata", "Amplitudes/", package="PoDCall")
ssPath <- system.file("extdata", "Sample_names.csv", package="PoDCall")

## Run PodCall
podcallResults <- podcallDdpcr(dataDirectory=dataPath,
                                sampleSheetFile=ssPath,
                                B=100, software="QuantaSoft")

}
