% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/podcallThresholds.R
\name{podcallThresholds}
\alias{podcallThresholds}
\title{podcallThresholds}
\usage{
podcallThresholds(plateData,
                        nrChannels=c(1,2)[2],
                        B=200,
                        Q=9,
                        refWell=1,
                        targetChannel=c(1,2,3,4,5,6)[1],
                        controlChannel=c(1,2,3,4,5,6)[2],
                        updateProgress=NULL)
}
\arguments{
\item{plateData}{List of data frames with amplitude data from a 96 well plate}

\item{nrChannels}{If single channel target and no control channel, set to 1,
if control channel is used, set to 2 (default=2)}

\item{B}{Number of permutations for the Likelihood Ratio Test (LRT)
(default=200)}

\item{Q}{Parameter for outlier calling (default=9)}

\item{refWell}{Reference well to calculate the shift in baseline (default=1)}

\item{targetChannel}{The channel nr used as target channel (default=1)}

\item{controlChannel}{The channel nr used as control channel (default=2)}

\item{updateProgress}{function to update progress bar in shiny app
(default=NULL)}
}
\value{
A table with results and metrics, one row per well.
}
\description{
Function sets threshold per channel per well and calculates
    concentrations. Results are returned as a data frame.
}
\examples{
## Path to example data
dataPath <- system.file("extdata", "Amplitudes/", package="PoDCall")

## Read in example data
dataList <- importAmplitudeData(dataDirectory=dataPath, skipLines=0)

## Set thresholds
thresholds <- podcallThresholds(plateData=dataList,
                                B=100)

}
