% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_generateProteoDiscography.R
\name{generateProteoDiscography}
\alias{generateProteoDiscography}
\title{Generate the annotation database (ProteoDiscography)}
\usage{
generateProteoDiscography(
  TxDb,
  genomeSeqs,
  useOnlySharedSeqlevels = TRUE,
  geneticCode = "Standard"
)
}
\arguments{
\item{TxDb}{(\link[GenomicFeatures]{TxDb}): TxDb object containing the genomic and transcriptomic annotations.}

\item{genomeSeqs}{(\link[Biostrings]{DNAStringSet} or \link[BSgenome]{BSgenome}): Genomic sequence of the respective genome.}

\item{useOnlySharedSeqlevels}{(logical): Should only shared seqlevels between the TxDb and genomeSeqs be kept?}

\item{geneticCode}{(character): Which codon-table should be used? Default is set to Standard, check \link[Biostrings]{GENETIC_CODE_TABLE} for additional options.}
}
\value{
ProteoDiscography
}
\description{
Generates a database containing the genomic and transcriptomic annotations which will be used downstream 
to integrate genomic variants and discover mutant protein sequences with ProteoDisco.

By default, only the common seqlevels between the TxDb and genomeSeqs will be kept..
}
\examples{
 # Generate a ProteoDiscography using existing TxDb and annotations.
 ProteoDiscography.hg19 <- ProteoDisco::generateProteoDiscography(
   TxDb = TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene, 
   genomeSeqs = BSgenome.Hsapiens.UCSC.hg19::BSgenome.Hsapiens.UCSC.hg19
 )
 
}
\author{
Job van Riet \email{j.vanriet@erasmusmc.nl}

Wesley van de Geer \email{w.vandegeer@erasmusmc.nl}
}
\concept{methods}
\keyword{methods}
