% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_genomicVariants.R
\name{importGenomicVariants}
\alias{importGenomicVariants}
\title{Import genomic variants into the ProteoDiscography}
\usage{
importGenomicVariants(
  ProteoDiscography,
  files,
  samplenames = NULL,
  removeExisting = FALSE,
  overwriteDuplicateSamples = TRUE,
  performAnchorCheck = TRUE,
  ignoreNonMatch = FALSE,
  threads = 1
)
}
\arguments{
\item{ProteoDiscography}{({ProteoDiscography}): ProteoDiscography object which stores the annotation and genomic sequences.}

\item{files}{(character): Path(s) to VCF or MAF files.}

\item{samplenames}{(character): Descriptive samplename(s) of the VCF files in the same order as input VCF file(s), if NULL the basename of the file will be used instead.}

\item{removeExisting}{(logical): Should previous mutations within the ProteoDiscography be removed?}

\item{overwriteDuplicateSamples}{(logical): Replace duplicate samples (TRUE) or throw an error if duplicate samples are found.}

\item{performAnchorCheck}{(logical): Should the reference anchor be check for consistency with the given genomic sequences?}

\item{ignoreNonMatch}{(logical): Should non-matching reference anchors be ignored? These mutations will be removed prior to appending.}

\item{threads}{(integer): Number of threads.}
}
\value{
{ProteoDiscography} with additional imported SNVs, MNVs and InDels.
}
\description{
Imports genomic variants (SNV, MNV and InDels) present within the supplied VCF/MAF files 
into the {ProteoDiscography} as a {VRanges}. This genomic variants can later be incorporated within transcript 
sequences at a later stage.
}
\examples{

ProteoDiscography.hg19 <- ProteoDisco::generateProteoDiscography(
  TxDb = TxDb.Hsapiens.UCSC.hg19.knownGene::TxDb.Hsapiens.UCSC.hg19.knownGene, 
  genomeSeqs = BSgenome.Hsapiens.UCSC.hg19::BSgenome.Hsapiens.UCSC.hg19
)

# Supply the ProteoDiscography with genomic variants to incorporate in downstream analysis. This can be one or multiple VCF / MAF files.
# Additional manual sequences and exon-exon mapping (i.e., splice junctions) can also be given as shown in the sections below.
ProteoDiscography.hg19 <- ProteoDisco::importGenomicVariants(
  ProteoDiscography = ProteoDiscography.hg19,
  # Provide the VCF / MAF files, if more then one supply a vector of files and corresponding samplenames.
  files = system.file('extdata', 'validationSet_hg19.vcf', package = 'ProteoDisco'), 
  # We can replace the original samples within the VCF with nicer names.
  samplenames = 'Validation Set (GRCh37)',
  # Number of threads used for parallelization.
  # We run samples sequentially and parallelize within (variant-wise multi-threading).
  threads = 1, 
  # To increase import-speed for this example, do not check for validity of the reference anchor with the given reference sequences.
  performAnchorCheck = FALSE
)
 
}
\author{
Job van Riet \email{j.vanriet@erasmusmc.nl}

Wesley van de Geer \email{w.vandegeer@erasmusmc.nl}
}
\concept{methods}
\keyword{methods}
